/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin2.uitoolkit.impl.awt;

import com.sun.applet2.Applet2Context;
import com.sun.applet2.Applet2Host;
import com.sun.applet2.preloader.CancelException;
import com.sun.applet2.preloader.Preloader;
import com.sun.applet2.preloader.event.AppletInitEvent;
import com.sun.applet2.preloader.event.DownloadEvent;
import com.sun.applet2.preloader.event.ErrorEvent;
import com.sun.applet2.preloader.event.PreloaderEvent;
import com.sun.deploy.net.JARSigningException;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.security.BlockedException;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.deploy.uitoolkit.ToolkitStore;
import com.sun.deploy.uitoolkit.impl.awt.ui.DownloadWindow;
import com.sun.deploy.util.SafeThreadFactory;
import com.sun.deploy.util.URLUtil;
import java.awt.Color;
import java.awt.Container;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.net.MalformedURLException;
import java.net.URL;
import sun.plugin.JavaRunTime;
import sun.plugin2.applet2.Plugin2Host;
import sun.plugin2.main.client.DisconnectedExecutionContext;
import sun.plugin2.uitoolkit.impl.awt.AWTGrayBoxPainter;
import sun.plugin2.util.ColorUtil;

public class AWTDefaultPreloader
extends Preloader {
    private Preloader webstartDP = null;
    private Container parentContainer = null;
    private AWTGrayBoxPainter grayBoxPainter;
    private GrayBoxListener grayBoxListener;
    private final GrayBoxPainterStarterThreadHolder grayBoxPainterStarter;
    private boolean gotError = false;
    private boolean hadSwitched = false;
    private Color bgColor = Color.white;
    private Color fgColor = Color.black;

    public AWTDefaultPreloader(Applet2Context stub, Container parent) {
        super(stub);
        this.parentContainer = parent;
        if (this.isDownloadDialogMode()) {
            this.webstartDP = new DownloadWindow();
            this.grayBoxPainterStarter = null;
        } else {
            this.grayBoxPainterStarter = new GrayBoxPainterStarterThreadHolder();
            this.grayBoxPainterStarter.start();
            this.webstartDP = null;
        }
    }

    private boolean isDownloadDialogMode() {
        Plugin2Host plugin2Host;
        Applet2Host host = this.ctx.getHost();
        return host instanceof Plugin2Host && (plugin2Host = (Plugin2Host)host).getAppletExecutionContext() instanceof DisconnectedExecutionContext;
    }

    private synchronized void markGotError() {
        this.gotError = true;
    }

    private synchronized boolean hasErrorOccurred() {
        return this.gotError;
    }

    private synchronized void resetErrorStatus() {
        this.gotError = false;
    }

    public Object getOwner() {
        this.grayBoxPainterStarter.waitTillDone();
        return this.parentContainer;
    }

    public boolean handleEvent(PreloaderEvent pe) throws CancelException {
        if (this.grayBoxPainterStarter != null) {
            return this.browserHandleEvent(pe);
        }
        return this.webstartHandleEvent(pe);
    }

    private boolean webstartHandleEvent(PreloaderEvent pe) throws CancelException {
        AppletInitEvent aie;
        int aieType;
        if (pe.getType() == 5 && ((aieType = (aie = (AppletInitEvent)pe).getSubtype()) == 3 || aieType == 4 || aieType == 2)) {
            this.ctx.getHost().showApplet();
        }
        return this.webstartDP.handleEvent(pe);
    }

    private boolean browserHandleEvent(PreloaderEvent pe) throws CancelException {
        this.grayBoxPainterStarter.waitTillDone();
        if (this.hasErrorOccurred()) {
            if (pe.getType() == 1) {
                this.resetErrorStatus();
            }
            return true;
        }
        switch (pe.getType()) {
            case 3: {
                DownloadEvent de = (DownloadEvent)pe;
                if (this.grayBoxPainter != null) {
                    this.grayBoxPainter.setProgress(de.getOverallPercentage());
                }
                return true;
            }
            case 6: {
                this.markGotError();
                if (this.grayBoxPainter != null) {
                    this.grayBoxPainter.finishPainting();
                }
                ErrorEvent ee = (ErrorEvent)pe;
                Throwable ex = ee.getException();
                boolean okReload = true;
                if (ex != null && (ex instanceof JARSigningException || ex instanceof BlockedException)) {
                    okReload = false;
                }
                String message = ex != null ? ex.getMessage() : null;
                this.ctx.getHost().showError(message, ex, okReload);
                return true;
            }
            case 7: {
                return true;
            }
            case 5: {
                AppletInitEvent aie = (AppletInitEvent)pe;
                if (!this.hadSwitched && (aie.getSubtype() == 3 || aie.getSubtype() == 4) || aie.getSubtype() == 6) {
                    this.shutdownGrayBoxPainter();
                    this.ctx.getHost().showApplet();
                    this.hadSwitched = true;
                }
                return true;
            }
            case 2: {
                return true;
            }
        }
        return false;
    }

    void handleReloadApplet() {
        this.ctx.getHost().reloadAppletPage();
    }

    public Color getBGColor() {
        this.grayBoxPainterStarter.waitTillDone();
        return this.bgColor;
    }

    public Color getFGColor() {
        this.grayBoxPainterStarter.waitTillDone();
        return this.fgColor;
    }

    public void shutdownGrayBoxPainter() {
        if (this.grayBoxPainterStarter.isAlive()) {
            this.grayBoxPainterStarter.interrupt();
        }
        if (this.grayBoxPainter != null) {
            this.grayBoxPainter.finishPainting();
            this.grayBoxPainter = null;
        }
        if (this.grayBoxListener != null) {
            if (this.parentContainer != null) {
                this.parentContainer.removeMouseListener(this.grayBoxListener);
            }
            this.grayBoxListener = null;
        }
    }

    private void setupColorAndText(String customBoxMessage) {
        ColorUtil.ColorRGB val;
        String boxBGColorStr = this.ctx.getParameter("boxbgcolor");
        if (boxBGColorStr != null && (val = ColorUtil.createColorRGB("boxbgcolor", boxBGColorStr)) != null) {
            this.bgColor = new Color(val.rgb);
        }
        this.grayBoxPainter.setBoxBGColor(this.bgColor);
        String boxFGColorStr = this.ctx.getParameter("boxfgcolor");
        if (boxFGColorStr != null && (val = ColorUtil.createColorRGB("boxfgcolor", boxFGColorStr)) != null) {
            this.fgColor = new Color(val.rgb);
        }
        this.grayBoxPainter.setBoxFGColor(this.fgColor);
        if (this.parentContainer != null) {
            this.parentContainer.setBackground(this.grayBoxPainter.getBoxBGColor());
            this.parentContainer.setForeground(this.grayBoxPainter.getBoxFGColor());
        }
        if (customBoxMessage != null) {
            this.grayBoxPainter.setWaitingMessage(customBoxMessage);
        } else {
            this.grayBoxPainter.setWaitingMessage(this.getWaitingMessage());
        }
    }

    public void doPaint(Graphics g) {
        this.grayBoxPainterStarter.waitTillDone();
        if (this.grayBoxPainter != null) {
            this.grayBoxPainter.paintGrayBox(g);
        }
    }

    protected String getWaitingMessage() {
        if (this.hasErrorOccurred()) {
            return ResourceManager.getString((String)"failed");
        }
        return ResourceManager.getString((String)"loading", (Object[])new Object[]{ResourceManager.getString((String)"java_applet")});
    }

    private class GrayBoxListener
    implements MouseListener,
    ActionListener {
        private PopupMenu popup;
        private MenuItem open_console;
        private MenuItem about_java;
        private String msg = null;
        private final Container parent;

        GrayBoxListener(Container parent, String msg) {
            this.msg = msg;
            this.parent = parent;
        }

        private PopupMenu getPopupMenu() {
            if (this.popup == null) {
                Font f = this.parent.getFont();
                Font menuFont = f.deriveFont(11.0f);
                this.popup = new PopupMenu();
                this.open_console = new MenuItem(ResourceManager.getString((String)"dialogfactory.menu.open_console"));
                this.open_console.setFont(menuFont);
                this.about_java = new MenuItem(ResourceManager.getString((String)"dialogfactory.menu.about_java"));
                this.about_java.setFont(menuFont);
                this.open_console.addActionListener(this);
                this.about_java.addActionListener(this);
                this.popup.add(this.open_console);
                this.popup.add("-");
                this.popup.add(this.about_java);
                this.parent.add(this.popup);
            }
            return this.popup;
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            Trace.msgPrintln((String)(this.msg != null ? this.msg : AWTDefaultPreloader.this.getWaitingMessage()), null, (TraceLevel)TraceLevel.BASIC);
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (e.isPopupTrigger() && AWTDefaultPreloader.this.hasErrorOccurred()) {
                this.getPopupMenu().show(e.getComponent(), e.getX(), e.getY());
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (e.isPopupTrigger() && AWTDefaultPreloader.this.hasErrorOccurred()) {
                this.getPopupMenu().show(e.getComponent(), e.getX(), e.getY());
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == this.open_console) {
                JavaRunTime.showJavaConsole(true);
            } else if (e.getSource() == this.about_java) {
                ToolkitStore.getUI().showAboutJavaDialog();
            }
        }
    }

    private class GrayBoxPainterStarter
    implements Runnable {
        private int state = 0;

        private GrayBoxPainterStarter() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void waitTillDone() {
            GrayBoxPainterStarter grayBoxPainterStarter = this;
            synchronized (grayBoxPainterStarter) {
                while (this.state == 0) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            GrayBoxPainterStarter grayBoxPainterStarter;
            boolean done = false;
            try {
                Trace.println((String)("GrayBox: parent = " + AWTDefaultPreloader.this.parentContainer), (TraceLevel)TraceLevel.PRELOADER);
                if (AWTDefaultPreloader.this.parentContainer != null) {
                    AWTDefaultPreloader.this.grayBoxPainter = new AWTGrayBoxPainter(AWTDefaultPreloader.this.parentContainer, AWTDefaultPreloader.this.ctx.getHost());
                    String userImage = AWTDefaultPreloader.this.ctx.getParameter("image");
                    if (userImage != null) {
                        try {
                            URL codebase = AWTDefaultPreloader.this.ctx.getCodeBase();
                            URL customImageURL = new URL(codebase, userImage);
                            if (!URLUtil.checkTargetURL((URL)codebase, (URL)customImageURL)) {
                                throw new SecurityException("Permission denied: " + customImageURL);
                            }
                            boolean centerImage = Boolean.valueOf(AWTDefaultPreloader.this.ctx.getParameter("centerimage"));
                            AWTDefaultPreloader.this.grayBoxPainter.setBoxBorder(AWTDefaultPreloader.this.ctx.getParameter("boxborder"));
                            AWTDefaultPreloader.this.grayBoxPainter.setCustomImageURL(customImageURL, centerImage);
                        }
                        catch (MalformedURLException e) {
                            Trace.printException((Throwable)e);
                        }
                    }
                    String customBoxMessage = AWTDefaultPreloader.this.ctx.getParameter("boxmessage");
                    AWTDefaultPreloader.this.setupColorAndText(customBoxMessage);
                    AWTDefaultPreloader.this.grayBoxPainter.beginPainting(Thread.currentThread().getThreadGroup());
                    AWTDefaultPreloader.this.grayBoxListener = new GrayBoxListener(AWTDefaultPreloader.this.parentContainer, customBoxMessage);
                    AWTDefaultPreloader.this.parentContainer.addMouseListener(AWTDefaultPreloader.this.grayBoxListener);
                }
                done = true;
                grayBoxPainterStarter = this;
            }
            catch (Throwable throwable) {
                GrayBoxPainterStarter grayBoxPainterStarter2 = this;
                synchronized (grayBoxPainterStarter2) {
                    this.state = done ? 1 : -1;
                    this.notifyAll();
                }
                throw throwable;
            }
            synchronized (grayBoxPainterStarter) {
                this.state = done ? 1 : -1;
                this.notifyAll();
            }
        }
    }

    private class GrayBoxPainterStarterThreadHolder {
        private final GrayBoxPainterStarter starter;
        private final Thread thread;

        private GrayBoxPainterStarterThreadHolder(GrayBoxPainterStarter starter) {
            this.thread = SafeThreadFactory.createThread((Runnable)starter);
            this.starter = starter;
            this.thread.setDaemon(true);
        }

        public void start() {
            this.thread.start();
        }

        private GrayBoxPainterStarterThreadHolder() {
            this(aWTDefaultPreloader.new GrayBoxPainterStarter());
        }

        public void waitTillDone() {
            this.starter.waitTillDone();
        }

        public boolean isAlive() {
            return this.thread.isAlive();
        }

        public void interrupt() {
            this.thread.interrupt();
        }
    }
}

