/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin.util;

import com.sun.applet2.preloader.CancelException;
import com.sun.applet2.preloader.Preloader;
import com.sun.applet2.preloader.event.DownloadEvent;
import com.sun.applet2.preloader.event.PreloaderEvent;
import com.sun.deploy.util.URLUtil;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.StringTokenizer;
import sun.net.ProgressEvent;
import sun.net.ProgressListener;
import sun.plugin.util.ProgressMonitor;

public class ProgressMonitorAdapter
implements ProgressListener {
    private int numJarTotal = 0;
    private int numberOfJarLoaded = 0;
    private final ArrayList<Object> progressSourceFilterList = new ArrayList();
    private URL[] jarURLs = new URL[0];
    private final HashMap<URL, ProgressEvent> downloadInProgressMap = new HashMap();
    private URL codebaseURL;
    Preloader delegate;

    public ProgressMonitorAdapter(Preloader d) {
        this.delegate = d;
    }

    public void setProgressFilter(URL codebase, String archives) {
        this.codebaseURL = codebase;
        if (archives != null) {
            ArrayList<URL> archiveList = new ArrayList<URL>();
            URL[] archiveURLs = new URL[]{};
            StringTokenizer st = new StringTokenizer(archives, ",", false);
            while (st.hasMoreTokens()) {
                String tok = st.nextToken().trim();
                try {
                    URL url = new URL(codebase, tok);
                    if (!URLUtil.checkTargetURL((URL)codebase, (URL)url)) {
                        throw new SecurityException("Permission denied: " + url);
                    }
                    archiveList.add(url);
                }
                catch (MalformedURLException e) {
                    e.printStackTrace();
                }
            }
            archiveURLs = new URL[archiveList.size()];
            int i = 0;
            Iterator iter = archiveList.iterator();
            while (iter.hasNext()) {
                archiveURLs[i] = (URL)iter.next();
                ++i;
            }
            this.jarURLs = archiveURLs;
            this.numJarTotal = archiveURLs.length;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void progressStart(ProgressEvent evt) {
        ArrayList<Object> arrayList = this.progressSourceFilterList;
        synchronized (arrayList) {
            if (this.progressSourceFilterList.contains(evt.getSource())) {
                return;
            }
            if (this.numJarTotal > 0) {
                for (URL jarURL : this.jarURLs) {
                    if (!evt.getURL().equals(jarURL)) continue;
                    this.progressSourceFilterList.add(evt.getSource());
                    HashMap<URL, ProgressEvent> hashMap = this.downloadInProgressMap;
                    synchronized (hashMap) {
                        this.downloadInProgressMap.put(evt.getURL(), evt);
                        break;
                    }
                }
            } else if (evt.getURL().toString().startsWith(this.codebaseURL.toString())) {
                this.progressSourceFilterList.add(evt.getSource());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void progressUpdate(ProgressEvent evt) {
        Cloneable cloneable = this.progressSourceFilterList;
        synchronized (cloneable) {
            if (this.progressSourceFilterList.isEmpty()) {
                this.progressStart(evt);
            }
            if (!this.progressSourceFilterList.contains(evt.getSource())) {
                return;
            }
        }
        if (this.numJarTotal > 0) {
            cloneable = this.downloadInProgressMap;
            synchronized (cloneable) {
                this.downloadInProgressMap.put(evt.getURL(), evt);
            }
            this.sendEvent(evt.getURL(), ProgressMonitor.getProgress(evt), ProgressMonitor.getExpected(evt), this.getCurrentProgress());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void progressFinish(ProgressEvent evt) {
        int currentProgress = 0;
        boolean sent = false;
        Cloneable cloneable = this.progressSourceFilterList;
        synchronized (cloneable) {
            if (!this.progressSourceFilterList.contains(evt.getSource())) {
                return;
            }
            this.progressSourceFilterList.remove(evt.getSource());
        }
        if (ProgressMonitor.getProgress(evt) == 0L) {
            this.downloadInProgressMap.remove(evt.getURL());
            return;
        }
        if (this.numJarTotal > 0) {
            cloneable = this.downloadInProgressMap;
            synchronized (cloneable) {
                this.downloadInProgressMap.remove(evt.getURL());
                ++this.numberOfJarLoaded;
                currentProgress = this.numJarTotal == this.numberOfJarLoaded ? 100 : this.getCurrentProgress();
            }
        } else {
            int step = (100 - currentProgress) / 2;
            currentProgress += step;
        }
        if (!sent) {
            this.sendEvent(evt.getURL(), ProgressMonitor.getProgress(evt), ProgressMonitor.getExpected(evt), currentProgress);
        }
    }

    private void sendEvent(URL u, long loaded, long expected, long overalProgress) {
        try {
            this.delegate.handleEvent((PreloaderEvent)new DownloadEvent(0, u, null, null, (long)((int)loaded), (long)((int)expected), (int)overalProgress));
        }
        catch (CancelException cancelException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getCurrentProgress() {
        if (this.numJarTotal == 0) {
            return 100;
        }
        double step = 100.0 / (double)this.numJarTotal;
        double progress = step * (double)this.numberOfJarLoaded;
        HashMap<URL, ProgressEvent> hashMap = this.downloadInProgressMap;
        synchronized (hashMap) {
            for (ProgressEvent pe : this.downloadInProgressMap.values()) {
                long expected = ProgressMonitor.getExpected(pe);
                if (expected > 0L) {
                    progress += step * (double)ProgressMonitor.getProgress(pe) / (double)expected;
                    continue;
                }
                progress += step / 2.0;
            }
        }
        if (progress < 100.0) {
            return (int)progress;
        }
        return 100;
    }
}

