/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin.security;

import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.security.CeilingPolicy;
import com.sun.deploy.security.SecureCookiePermission;
import com.sun.deploy.security.TrustDecider;
import com.sun.deploy.security.ruleset.DeploymentRuleSet;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.deploy.ui.AppInfo;
import com.sun.deploy.uitoolkit.ToolkitStore;
import com.sun.deploy.util.JarUtil;
import com.sun.deploy.util.URLUtil;
import java.awt.AWTPermission;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Policy;
import java.security.PrivilegedAction;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.PropertyPermission;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipFile;
import sun.applet.AppletClassLoader;
import sun.awt.AppContext;
import sun.net.ProgressSource;
import sun.net.www.ParseUtil;
import sun.plugin.security.ActivatorSecurityManager;
import sun.plugin.util.ProgressMonitor;

public final class PluginClassLoader
extends AppletClassLoader {
    private static RuntimePermission usePolicyPermission;
    private URL base;
    private HashMap<String, File> JARJARtoJAR = new HashMap();
    private DeploymentRuleSet drs = DeploymentRuleSet.getDefault();

    public PluginClassLoader(URL base) {
        super(base);
        this.base = base;
    }

    public URL getBaseURL() {
        return this.base;
    }

    protected PermissionCollection getPermissions(CodeSource cs) {
        String path;
        PermissionCollection perms = super.getPermissions(cs);
        URL url = cs.getLocation();
        if (url != null && url.getProtocol().equals("file") && (path = ParseUtil.decode(url.getFile())) != null) {
            path = path.replace('/', File.separatorChar);
            Object axBridgePath = File.separator + System.getProperty("java.home") + File.separator + "axbridge" + File.separator + "lib";
            try {
                path = new File(path).getCanonicalPath();
                axBridgePath = new File((String)axBridgePath).getCanonicalPath();
                if (path != null && axBridgePath != null && path.startsWith((String)axBridgePath)) {
                    perms.add(new AllPermission());
                    return perms;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        PermissionCollection perms2 = null;
        Policy newPolicy = AccessController.doPrivileged(new PrivilegedAction<Policy>(){

            @Override
            public Policy run() {
                return Policy.getPolicy();
            }
        });
        perms2 = newPolicy.getPermissions(cs);
        perms.add(new PropertyPermission("browser", "read"));
        perms.add(new PropertyPermission("browser.version", "read"));
        perms.add(new PropertyPermission("browser.vendor", "read"));
        perms.add(new PropertyPermission("http.agent", "read"));
        perms.add(new PropertyPermission("javapi.*", "read,write"));
        perms.add(new PropertyPermission("javaws.*", "read,write"));
        perms.add(new PropertyPermission("jnlp.*", "read,write"));
        perms.add(new PropertyPermission("javaplugin.version", "read"));
        if (usePolicyPermission == null) {
            usePolicyPermission = new RuntimePermission("usePolicy");
        }
        if (!perms2.implies(usePolicyPermission) && cs.getCertificates() != null) {
            try {
                if (TrustDecider.isAllPermissionGranted((CodeSource)cs, (AppInfo)new AppInfo(), (DeploymentRuleSet)this.drs, null) != 0L) {
                    CeilingPolicy.addTrustedPermissions((PermissionCollection)perms);
                }
            }
            catch (CertificateExpiredException e1) {
                Trace.securityPrintException((Throwable)e1, (String)ResourceManager.getString((String)"rsa.cert_expired"), (String)ResourceManager.getString((String)"security.dialog.caption"));
            }
            catch (CertificateNotYetValidException e2) {
                Trace.securityPrintException((Throwable)e2, (String)ResourceManager.getString((String)"rsa.cert_notyieldvalid"), (String)ResourceManager.getString((String)"security.dialog.caption"));
            }
            catch (Exception e3) {
                Trace.securityPrintException((Throwable)e3, (String)ResourceManager.getString((String)"rsa.general_error"), (String)ResourceManager.getString((String)"security.dialog.caption"));
            }
        }
        if (!perms.implies(new AWTPermission("accessClipboard")) && !perms2.implies(new AWTPermission("accessClipboard"))) {
            ToolkitStore.get().getAppContext().put((Object)"UNTRUSTED_CLIPBOARD_ACCESS_KEY", (Object)Boolean.TRUE);
        }
        perms.add((Permission)new SecureCookiePermission(SecureCookiePermission.getURLOriginString((URL)cs.getLocation())));
        return perms;
    }

    public void addLocalJar(URL url) {
        this.addURL(url);
    }

    private void addInnerJarURL(File file) throws MalformedURLException {
        URL url = file.toURI().toURL();
        this.addURL(url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void addJar(String name) throws IOException {
        if (name.toUpperCase().endsWith(".JARJAR") && this.base.getProtocol().equalsIgnoreCase("file")) {
            File tempFile = null;
            String fullPath = this.base.toString() + name;
            if (!this.JARJARtoJAR.containsKey(fullPath)) {
                boolean bJarJar = false;
                try (ZipFile jf1 = null;){
                    boolean bSuccess;
                    FileOutputStream fos;
                    FilterOutputStream bos;
                    BufferedInputStream bis;
                    block23: {
                        jf1 = JarUtil.createJarFile((File)new File(this.base.getPath() + name), (boolean)true);
                        Enumeration<JarEntry> fileList = ((JarFile)jf1).entries();
                        int jarCounter = 0;
                        if (!fileList.hasMoreElements()) {
                            throw new IOException("Invalid jarjar file");
                        }
                        JarEntry entry = null;
                        while (fileList.hasMoreElements()) {
                            entry = fileList.nextElement();
                            if (entry.toString().toUpperCase().startsWith("META-INF/")) continue;
                            if (!entry.toString().toUpperCase().endsWith(".JAR")) {
                                throw new IOException("Invalid entry in jarjar file.");
                            }
                            if (++jarCounter <= 1) continue;
                        }
                        if (jarCounter > 1) {
                            entry = null;
                            throw new IOException("Multiple JAR files inside JARJAR file");
                        }
                        byte[] buffer = new byte[8192];
                        bis = null;
                        bos = null;
                        fos = null;
                        InputStream is = ((JarFile)jf1).getInputStream(entry);
                        bSuccess = false;
                        try {
                            int n;
                            tempFile = File.createTempFile(entry.toString().substring(0, entry.toString().lastIndexOf(46)), ".jar");
                            Trace.msgPrintln((String)"pluginclassloader.created_file", (Object[])new Object[]{tempFile.getPath()}, (TraceLevel)TraceLevel.BASIC);
                            this.updateJarProgress(name);
                            bis = new BufferedInputStream(is);
                            fos = new FileOutputStream(tempFile);
                            bos = new BufferedOutputStream(fos);
                            while ((n = bis.read(buffer, 0, buffer.length)) != -1) {
                                ((BufferedOutputStream)bos).write(buffer, 0, n);
                            }
                            ((BufferedOutputStream)bos).flush();
                            bSuccess = true;
                            this.JARJARtoJAR.put(fullPath, tempFile);
                            try {
                                this.addInnerJarURL(tempFile);
                            }
                            catch (MalformedURLException e) {
                                throw new IllegalArgumentException(name);
                            }
                            if (bis == null) break block23;
                        }
                        catch (Throwable throwable) {
                            if (bis != null) {
                                bis.close();
                            }
                            if (bos != null) {
                                bos.close();
                            }
                            if (fos != null) {
                                fos.close();
                            }
                            bis = null;
                            bos = null;
                            fos = null;
                            if (bSuccess) throw throwable;
                            Trace.msgPrintln((String)"pluginclassloader.empty_file", (Object[])new Object[]{tempFile.getName()}, (TraceLevel)TraceLevel.BASIC);
                            if (tempFile == null) throw throwable;
                            tempFile.delete();
                            throw throwable;
                        }
                        bis.close();
                    }
                    if (bos != null) {
                        bos.close();
                    }
                    if (fos != null) {
                        fos.close();
                    }
                    bis = null;
                    bos = null;
                    fos = null;
                    if (bSuccess) return;
                    Trace.msgPrintln((String)"pluginclassloader.empty_file", (Object[])new Object[]{tempFile.getName()}, (TraceLevel)TraceLevel.BASIC);
                    if (tempFile == null) return;
                    tempFile.delete();
                    return;
                }
            }
            tempFile = this.JARJARtoJAR.get(fullPath);
            if (tempFile != null) {
                try {
                    this.addInnerJarURL(tempFile);
                }
                catch (MalformedURLException e) {
                    throw new IllegalArgumentException(name);
                }
            }
            this.updateJarProgress(name);
            return;
        }
        super.addJar(name);
        this.updateJarProgress(name);
    }

    private void updateJarProgress(String name) {
        if (this.base.getProtocol().equalsIgnoreCase("file")) {
            try {
                URL url = new URL(this.base, name);
                if (!URLUtil.checkTargetURL((URL)this.base, (URL)url)) {
                    throw new SecurityException("Permission denied: " + url);
                }
                boolean meteredInput = ProgressMonitor.get().shouldMeterInput(url, "GET");
                if (meteredInput) {
                    ProgressSource ps = new ProgressSource(url, "GET", 10000L);
                    ps.beginTracking();
                    ps.updateProgress(10000L, 10000L);
                    ps.finishTracking();
                    ps.close();
                }
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release(AppContext ac) {
        if (!this.JARJARtoJAR.isEmpty()) {
            Trace.msgPrintln((String)"pluginclassloader.deleting_files");
            Set<String> keys = this.JARJARtoJAR.keySet();
            for (String key : keys) {
                File tempFile = this.JARJARtoJAR.get(key);
                if (tempFile == null) continue;
                Trace.msgPrintln((String)"pluginclassloader.file", (Object[])new Object[]{tempFile.getPath()}, (TraceLevel)TraceLevel.BASIC);
                tempFile.delete();
            }
            this.JARJARtoJAR.clear();
        }
        if (ac == null) {
            return;
        }
        ActivatorSecurityManager sm = (ActivatorSecurityManager)((Object)System.getSecurityManager());
        ThreadGroup g = ac.getThreadGroup();
        sm.lockThreadGroup(g);
        try {
            ac.dispose();
        }
        catch (IllegalThreadStateException key) {
        }
        catch (Throwable t) {
            Trace.printException((Throwable)t);
        }
        finally {
            sm.unlockThreadGroup(g);
        }
    }

    public AppContext resetAppContext() {
        return super.resetAppContext();
    }
}

