/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin.com;

import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.trace.Trace;
import java.lang.reflect.Array;
import java.text.NumberFormat;
import java.text.ParseException;
import netscape.javascript.JSObject;
import sun.plugin.com.DispatchImpl;
import sun.plugin.com.WrapperJSObject;

public class TypeConverter {
    static Object[] convertObjectArray(Class<?>[] clazzArray, Object[] params) throws IllegalArgumentException {
        if (params == null || params.length == 0) {
            return params;
        }
        if (clazzArray.length != params.length) {
            throw new IllegalArgumentException(ResourceManager.getString((String)"com.method.argCountInvalid"));
        }
        Object[] result = new Object[params.length];
        for (int i = 0; i < params.length; ++i) {
            result[i] = TypeConverter.convertObject(clazzArray[i], params[i]);
        }
        return result;
    }

    public static Object convertObject(Class<?> clazz, Object param) throws IllegalArgumentException {
        if (param == null) {
            return param;
        }
        Class<?> paramClazz = param.getClass();
        Trace.msgLiveConnectPrintln((String)"com.field.needsConversion", (Object[])new Object[]{paramClazz.getName(), clazz.getName()});
        if (clazz.isAssignableFrom(paramClazz)) {
            return param;
        }
        if (clazz.equals(JSObject.class)) {
            return new WrapperJSObject(param);
        }
        if (param instanceof DispatchImpl) {
            return ((DispatchImpl)param).getWrappedObject();
        }
        if (clazz == String.class) {
            if (param instanceof Number) {
                NumberFormat nf = NumberFormat.getNumberInstance();
                try {
                    return nf.parse(param.toString()).toString();
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
            return param.toString();
        }
        if (clazz.isArray()) {
            if (paramClazz.isArray()) {
                Class<?> compType = clazz.getComponentType();
                int len = Array.getLength(param);
                Object result = Array.newInstance(compType, len);
                for (int i = 0; i < len; ++i) {
                    Array.set(result, i, TypeConverter.convertObject(compType, Array.get(param, i)));
                }
                return result;
            }
        } else if (clazz.isPrimitive() || Number.class.isAssignableFrom(clazz) || clazz == Character.class || clazz == Boolean.class) {
            String clazzName = clazz.getName();
            boolean number = param instanceof Number;
            boolean string = param instanceof String;
            if (clazzName.equals("boolean") || clazzName.equals("java.lang.Boolean")) {
                return Boolean.valueOf(param.toString());
            }
            if (clazzName.equals("byte") || clazzName.equals("java.lang.Byte")) {
                if (string) {
                    return Byte.valueOf((String)param);
                }
                if (number) {
                    return ((Number)param).byteValue();
                }
            } else if (clazzName.equals("short") || clazzName.equals("java.lang.Short")) {
                if (string) {
                    return Short.valueOf((String)param);
                }
                if (number) {
                    return ((Number)param).shortValue();
                }
            } else if (clazzName.equals("int") || clazzName.equals("java.lang.Integer")) {
                if (string) {
                    return Integer.valueOf((String)param);
                }
                if (number) {
                    return ((Number)param).intValue();
                }
            } else if (clazzName.equals("long") || clazzName.equals("java.lang.Long")) {
                if (string) {
                    return Long.valueOf((String)param);
                }
                if (number) {
                    return ((Number)param).longValue();
                }
            } else if (clazzName.equals("float") || clazzName.equals("java.lang.Float")) {
                if (string) {
                    return Float.valueOf((String)param);
                }
                if (number) {
                    return Float.valueOf(((Number)param).floatValue());
                }
            } else if (clazzName.equals("double") || clazzName.equals("java.lang.Double")) {
                if (string) {
                    return Double.valueOf((String)param);
                }
                if (number) {
                    return ((Number)param).doubleValue();
                }
            } else if (clazzName.equals("char") || clazzName.equals("java.lang.Character")) {
                if (string) {
                    return Character.valueOf((char)Short.decode((String)param).shortValue());
                }
                if (number) {
                    return Character.valueOf((char)((Number)param).shortValue());
                }
            } else {
                return param;
            }
        }
        throw new IllegalArgumentException(paramClazz.getName() + ResourceManager.getString((String)"com.field.typeInvalid") + clazz.getName());
    }
}

