/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin;

import com.sun.deploy.config.Config;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.trace.FileTraceListener;
import com.sun.deploy.trace.LoggerTraceListener;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.deploy.trace.TraceListener;
import com.sun.deploy.uitoolkit.ToolkitStore;
import com.sun.deploy.uitoolkit.ui.ConsoleController;
import com.sun.deploy.uitoolkit.ui.ConsoleTraceListener;
import com.sun.deploy.uitoolkit.ui.ConsoleWindow;
import com.sun.deploy.util.SystemPropertyUtil;
import java.io.File;
import java.util.logging.Level;
import sun.plugin.util.UserProfile;

public class JavaRunTime {
    private static boolean traceInit = false;
    private static ConsoleWindow console = null;
    private static final ConsoleTraceListener ctl = new ConsoleTraceListener();
    private static ConsoleController controller = null;

    private static synchronized ConsoleWindow getJavaConsole() {
        JavaRunTime.initTraceEnvironment();
        if (console == null) {
            console = ToolkitStore.getUI().getConsole(controller);
            ctl.setConsole(console);
            console.clear();
        }
        return console;
    }

    public static synchronized void initTraceEnvironment() {
        JavaRunTime.initTraceEnvironment(null);
    }

    public static synchronized void initTraceEnvironment(ConsoleController cctrl) {
        File parent;
        if (traceInit) {
            return;
        }
        traceInit = true;
        Trace.clearTraceListeners();
        File logDir = new File(UserProfile.getLogDirectory());
        if (!logDir.exists()) {
            logDir.mkdirs();
        }
        if (cctrl != null) {
            controller = cctrl;
        } else {
            try {
                controller = (ConsoleController)Class.forName("sun.plugin.util.PluginConsoleController").getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        Trace.addTraceListener((TraceListener)ctl);
        boolean pluginTrace = Config.getBooleanProperty((String)"javaplugin.trace");
        boolean deployTrace = Config.getBooleanProperty((String)"deployment.trace");
        String initTraceLevel = null;
        if (pluginTrace) {
            initTraceLevel = Config.getStringProperty((String)"javaplugin.trace.option");
        } else if (deployTrace) {
            initTraceLevel = Config.getStringProperty((String)"deployment.trace.level");
        }
        if (pluginTrace || deployTrace) {
            try {
                Boolean overWrite;
                if (initTraceLevel == null || initTraceLevel.equals("")) {
                    Trace.setEnabled((TraceLevel)TraceLevel.BASIC, (boolean)true);
                    Trace.setEnabled((TraceLevel)TraceLevel.NETWORK, (boolean)true);
                    Trace.setEnabled((TraceLevel)TraceLevel.CACHE, (boolean)true);
                    Trace.setEnabled((TraceLevel)TraceLevel.TEMP, (boolean)true);
                    Trace.setEnabled((TraceLevel)TraceLevel.SECURITY, (boolean)true);
                    Trace.setEnabled((TraceLevel)TraceLevel.EXTENSIONS, (boolean)true);
                    Trace.setEnabled((TraceLevel)TraceLevel.LIVECONNECT, (boolean)true);
                } else {
                    Trace.setInitialTraceLevel((String)initTraceLevel);
                }
                File traceFile = null;
                boolean customedTrace = false;
                String traceFilename = Config.getStringProperty((String)"deployment.javapi.trace.filename");
                if (traceFilename != null && traceFilename.trim().length() != 0) {
                    traceFile = new File(traceFilename);
                    parent = traceFile.getParentFile();
                    if (parent != null) {
                        parent.mkdirs();
                    }
                    traceFile.createNewFile();
                    if (traceFile.exists()) {
                        customedTrace = true;
                    } else {
                        traceFile = null;
                    }
                }
                if (traceFile == null && Boolean.TRUE.equals(overWrite = SystemPropertyUtil.getBooleanProperty((String)"javaplugin.outputfiles.overwrite"))) {
                    StringBuilder nameBuffer = new StringBuilder();
                    nameBuffer.append(logDir);
                    nameBuffer.append(File.separator);
                    nameBuffer.append("plugin");
                    String version = SystemPropertyUtil.getProperty((String)"javaplugin.version");
                    nameBuffer.append(version);
                    nameBuffer.append(".trace");
                    traceFile = new File(nameBuffer.toString());
                }
                FileTraceListener ftl = FileTraceListener.getOrCreateSharedInstance((File)traceFile, (File)logDir, (String)"plugin", (String)".trace", (boolean)false, (boolean)customedTrace);
                Trace.addTraceListener((TraceListener)ftl);
            }
            catch (Exception e) {
                Trace.println((String)"can not write to trace file", (TraceLevel)TraceLevel.BASIC);
                Trace.ignored((Throwable)e);
            }
        }
        if (Config.getBooleanProperty((String)"deployment.log")) {
            try {
                LoggerTraceListener ltl;
                File logFile = null;
                boolean customedLog = false;
                String logFilename = Config.getStringProperty((String)"deployment.javapi.log.filename");
                if (logFilename != null && logFilename.trim().length() != 0) {
                    logFile = new File(logFilename);
                    parent = logFile.getParentFile();
                    if (parent != null) {
                        parent.mkdirs();
                    }
                    logFile.createNewFile();
                    if (logFile.exists()) {
                        customedLog = true;
                    } else {
                        logFile = null;
                    }
                }
                if ((ltl = LoggerTraceListener.getOrCreateSharedInstance((String)"sun.plugin", logFile, (File)logDir, (String)"plugin", (String)".log", (boolean)customedLog)) != null) {
                    ltl.getLogger().setLevel(Level.ALL);
                    controller.setLogger(ltl.getLogger());
                    Trace.addTraceListener((TraceListener)ltl);
                }
            }
            catch (Exception e) {
                Trace.println((String)"can not write to log file", (TraceLevel)TraceLevel.BASIC);
                Trace.ignored((Throwable)e);
            }
        }
    }

    public static boolean isJavaConsoleVisible() {
        if (console == null) {
            return false;
        }
        return console.isVisible();
    }

    public static void showJavaConsole(boolean visible) {
        ConsoleWindow cw = JavaRunTime.getJavaConsole();
        if (cw != null) {
            cw.setVisible(visible);
        }
    }

    public static void showOldPluginWarning() {
        ConsoleWindow cw = JavaRunTime.getJavaConsole();
        if (cw != null) {
            cw.append(ResourceManager.getString((String)"console.show.oldplugin.warning"));
        }
    }
}

