/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.util;

import com.sun.deploy.config.Config;
import com.sun.deploy.trace.Trace;
import java.lang.reflect.Method;
import java.nio.Buffer;

public abstract class BufferWrapper {
    private final Buffer buffer;

    public BufferWrapper(Buffer buffer) {
        this.buffer = buffer;
    }

    public int limit() {
        return this.buffer.limit();
    }

    public Buffer limit(int n) {
        Buffer buffer = this.buffer;
        if (Config.isJavaVersionAtLeast9()) {
            buffer = this.buffer.limit(n);
        } else {
            try {
                Method method = this.buffer.getClass().getMethod("limit", Integer.TYPE);
                buffer = (Buffer)method.invoke((Object)this.buffer, n);
            }
            catch (Throwable throwable) {
                Trace.ignored(throwable);
            }
        }
        return buffer;
    }

    public Buffer position(int n) {
        Buffer buffer = this.buffer;
        if (Config.isJavaVersionAtLeast9()) {
            buffer = this.buffer.position(n);
        } else {
            try {
                Method method = this.buffer.getClass().getMethod("position", Integer.TYPE);
                buffer = (Buffer)method.invoke((Object)this.buffer, n);
            }
            catch (Throwable throwable) {
                Trace.ignored(throwable);
            }
        }
        return buffer;
    }

    public Buffer mark() {
        if (Config.isJavaVersionAtLeast9()) {
            return this.buffer.mark();
        }
        return BufferWrapper.invokeNoArgMethod(this.buffer, "mark");
    }

    public Buffer reset() {
        if (Config.isJavaVersionAtLeast9()) {
            return this.buffer.reset();
        }
        return BufferWrapper.invokeNoArgMethod(this.buffer, "reset");
    }

    public Buffer clear() {
        if (Config.isJavaVersionAtLeast9()) {
            return this.buffer.clear();
        }
        return BufferWrapper.invokeNoArgMethod(this.buffer, "clear");
    }

    public Buffer flip() {
        if (Config.isJavaVersionAtLeast9()) {
            return this.buffer.flip();
        }
        return BufferWrapper.invokeNoArgMethod(this.buffer, "flip");
    }

    public Buffer rewind() {
        if (Config.isJavaVersionAtLeast9()) {
            return this.buffer.rewind();
        }
        return BufferWrapper.invokeNoArgMethod(this.buffer, "rewind");
    }

    public int capacity() {
        return this.buffer.capacity();
    }

    public int remaining() {
        return this.buffer.remaining();
    }

    public int position() {
        return this.buffer.position();
    }

    public boolean hasRemaining() {
        return this.buffer.hasRemaining();
    }

    public Buffer getBuffer() {
        return this.buffer;
    }

    protected static Buffer invokeNoArgMethod(Buffer buffer, String string) {
        Buffer buffer2 = buffer;
        try {
            Method method = buffer.getClass().getMethod(string, new Class[0]);
            buffer2 = (Buffer)method.invoke((Object)buffer, new Object[0]);
        }
        catch (Throwable throwable) {
            Trace.ignored(throwable);
        }
        return buffer2;
    }
}

