/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.security;

import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.ui.AppInfo;
import com.sun.deploy.uitoolkit.ToolkitStore;
import java.security.CodeSource;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateRevokedException;

public class BlockedException
extends SecurityException {
    private static final long serialVersionUID = 3712667492700077030L;
    private final CodeSource codeSource;
    private AppInfo ai;
    private String message;
    private String masthead;
    private String mainText;
    private volatile boolean shown = false;

    public BlockedException(String string, Throwable throwable) {
        this(null, null, string, throwable, null, null);
    }

    public BlockedException(String string, Throwable throwable, CodeSource codeSource, AppInfo appInfo) {
        this(null, null, string, throwable, codeSource, appInfo);
    }

    public BlockedException(String string, Throwable throwable, CodeSource codeSource, AppInfo appInfo, boolean bl) {
        this(null, null, string, throwable, codeSource, appInfo);
        this.shown = bl;
    }

    public BlockedException(String string, String string2, String string3, Throwable throwable, CodeSource codeSource, AppInfo appInfo) {
        super(string3, throwable);
        this.message = string3;
        this.codeSource = codeSource;
        this.ai = appInfo != null ? new AppInfo(appInfo) : new AppInfo();
        this.masthead = string != null ? string : ResourceManager.getString("deployment.blocked.ruleset.masthead");
        this.mainText = string2 != null ? string2 : ResourceManager.getString("deployment.blocked.maintext");
    }

    public CodeSource getCodeSource() {
        return this.codeSource;
    }

    public AppInfo getAppInfo() {
        return this.ai;
    }

    public String getReason() {
        Throwable throwable = this.getCause();
        String string = null;
        if (throwable instanceof CertificateRevokedException) {
            string = this.getMessage("security.badcert.blocked.revoked.reason");
        } else if (throwable instanceof CertificateExpiredException) {
            string = this.getMessage("security.badcert.blocked.expired.reason");
        } else if (throwable != null) {
            string = throwable.getLocalizedMessage();
        }
        if (string == null || string.isEmpty()) {
            string = this.getLocalizedMessage();
        }
        return string;
    }

    private String getMessage(String string) {
        return ResourceManager.getString(string);
    }

    public void showDialog() {
        if (!this.shown) {
            this.shown = true;
            String string = this.getMessage("deployment.blocked.title");
            String string2 = this.getMessage("common.ok_btn");
            String string3 = this.getMessage("common.detail.button");
            this.ai.setVendor(null);
            this.ai.setBlockedText(this.mainText);
            ToolkitStore.getUI().showBlockedDialog(null, this.ai, string, this.masthead, this.message, string2, string3, null);
        }
    }
}

