/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin.dom.css;

import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.css.CSSRule;
import org.w3c.dom.css.CSSRuleList;
import sun.plugin.dom.DOMObject;
import sun.plugin.dom.DOMObjectFactory;
import sun.plugin.dom.DOMObjectHelper;
import sun.plugin.dom.stylesheets.StyleSheet;

public class CSSStyleSheet
extends StyleSheet
implements org.w3c.dom.css.CSSStyleSheet {
    public CSSStyleSheet(DOMObject obj, Document doc) {
        super(obj, doc);
    }

    @Override
    public CSSRule getOwnerRule() {
        return DOMObjectFactory.createCSSRule(this.obj.getMember("ownerRule"), this.doc);
    }

    @Override
    public CSSRuleList getCssRules() {
        return DOMObjectFactory.createCSSRuleList(this.obj.getMember("cssRules"), this.doc);
    }

    @Override
    public int insertRule(String rule, int index) throws DOMException {
        String result = null;
        try {
            rule = rule.trim();
            int selectorIndex = rule.indexOf(123);
            if (selectorIndex <= 0 || !rule.endsWith("}")) {
                throw new IllegalArgumentException("Invalid Css text");
            }
            String selector = rule.substring(0, selectorIndex);
            rule = rule.substring(selectorIndex + 1, rule.length() - 1);
            result = DOMObjectHelper.callStringMethod(this.obj, "addRule", new Object[]{selector, rule, new Integer(index)});
        }
        catch (DOMException e) {
            result = DOMObjectHelper.callStringMethod(this.obj, "insertRule", new Object[]{rule, new Integer(index)});
        }
        if (result != null) {
            return Integer.parseInt(result);
        }
        return 0;
    }

    @Override
    public void deleteRule(int index) throws DOMException {
        try {
            DOMObjectHelper.callStringMethod(this.obj, "removeRule", new Object[]{new Integer(index)});
        }
        catch (DOMException e) {
            DOMObjectHelper.callStringMethod(this.obj, "deleteRule", new Object[]{new Integer(index)});
        }
    }
}

