/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin.dom;

import java.lang.reflect.Constructor;
import java.util.HashMap;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.css.CSSRule;
import org.w3c.dom.html.HTMLDocument;
import sun.plugin.dom.DOMObject;
import sun.plugin.dom.core.Attr;
import sun.plugin.dom.core.CDATASection;
import sun.plugin.dom.core.Comment;
import sun.plugin.dom.core.DocumentFragment;
import sun.plugin.dom.core.NamedNodeMap;
import sun.plugin.dom.core.Text;
import sun.plugin.dom.css.CSSCharsetRule;
import sun.plugin.dom.css.CSSFontFaceRule;
import sun.plugin.dom.css.CSSImportRule;
import sun.plugin.dom.css.CSSMediaRule;
import sun.plugin.dom.css.CSSPageRule;
import sun.plugin.dom.css.CSSPrimitiveValue;
import sun.plugin.dom.css.CSSRuleList;
import sun.plugin.dom.css.CSSStyleDeclaration;
import sun.plugin.dom.css.CSSStyleRule;
import sun.plugin.dom.css.CSSStyleSheet;
import sun.plugin.dom.css.CSSUnknownRule;
import sun.plugin.dom.css.CSSValue;
import sun.plugin.dom.css.CSSValueList;
import sun.plugin.dom.css.Counter;
import sun.plugin.dom.css.RGBColor;
import sun.plugin.dom.css.Rect;
import sun.plugin.dom.exception.PluginNotSupportedException;
import sun.plugin.dom.html.HTMLAnchorElement;
import sun.plugin.dom.html.HTMLAppletElement;
import sun.plugin.dom.html.HTMLAreaElement;
import sun.plugin.dom.html.HTMLBRElement;
import sun.plugin.dom.html.HTMLBaseElement;
import sun.plugin.dom.html.HTMLBodyElement;
import sun.plugin.dom.html.HTMLCollection;
import sun.plugin.dom.html.HTMLDListElement;
import sun.plugin.dom.html.HTMLDirectoryElement;
import sun.plugin.dom.html.HTMLDivElement;
import sun.plugin.dom.html.HTMLElement;
import sun.plugin.dom.html.HTMLFieldSetElement;
import sun.plugin.dom.html.HTMLFontElement;
import sun.plugin.dom.html.HTMLFormElement;
import sun.plugin.dom.html.HTMLFrameElement;
import sun.plugin.dom.html.HTMLFrameSetElement;
import sun.plugin.dom.html.HTMLHRElement;
import sun.plugin.dom.html.HTMLHeadElement;
import sun.plugin.dom.html.HTMLHeadingElement;
import sun.plugin.dom.html.HTMLHtmlElement;
import sun.plugin.dom.html.HTMLIFrameElement;
import sun.plugin.dom.html.HTMLImageElement;
import sun.plugin.dom.html.HTMLInputElement;
import sun.plugin.dom.html.HTMLIsIndexElement;
import sun.plugin.dom.html.HTMLLIElement;
import sun.plugin.dom.html.HTMLLabelElement;
import sun.plugin.dom.html.HTMLLegendElement;
import sun.plugin.dom.html.HTMLLinkElement;
import sun.plugin.dom.html.HTMLMapElement;
import sun.plugin.dom.html.HTMLMenuElement;
import sun.plugin.dom.html.HTMLMetaElement;
import sun.plugin.dom.html.HTMLModElement;
import sun.plugin.dom.html.HTMLOListElement;
import sun.plugin.dom.html.HTMLObjectElement;
import sun.plugin.dom.html.HTMLOptGroupElement;
import sun.plugin.dom.html.HTMLOptionElement;
import sun.plugin.dom.html.HTMLParagraphElement;
import sun.plugin.dom.html.HTMLParamElement;
import sun.plugin.dom.html.HTMLPreElement;
import sun.plugin.dom.html.HTMLQuoteElement;
import sun.plugin.dom.html.HTMLScriptElement;
import sun.plugin.dom.html.HTMLSelectElement;
import sun.plugin.dom.html.HTMLStyleElement;
import sun.plugin.dom.html.HTMLTableCaptionElement;
import sun.plugin.dom.html.HTMLTableCellElement;
import sun.plugin.dom.html.HTMLTableColElement;
import sun.plugin.dom.html.HTMLTableElement;
import sun.plugin.dom.html.HTMLTableRowElement;
import sun.plugin.dom.html.HTMLTableSectionElement;
import sun.plugin.dom.html.HTMLTextAreaElement;
import sun.plugin.dom.html.HTMLTitleElement;
import sun.plugin.dom.html.HTMLUListElement;
import sun.plugin.dom.stylesheets.MediaList;
import sun.plugin.dom.stylesheets.StyleSheet;
import sun.plugin.dom.stylesheets.StyleSheetList;

public class DOMObjectFactory {
    private static HashMap elmTagClassMap = null;

    public static Node createNode(Object o, Document doc) {
        if (o != null && o instanceof DOMObject) {
            DOMObject obj = (DOMObject)o;
            int nodeType = ((Number)obj.getMember("nodeType")).intValue();
            switch (nodeType) {
                case 1: {
                    return DOMObjectFactory.createHTMLElement(obj, (HTMLDocument)doc);
                }
                case 2: {
                    return DOMObjectFactory.createAttr(obj, doc);
                }
                case 3: {
                    return new Text(obj, doc);
                }
                case 4: {
                    return new CDATASection(obj, doc);
                }
                case 5: {
                    throw new PluginNotSupportedException("Entity reference nodes are not supported");
                }
                case 6: {
                    throw new PluginNotSupportedException("Entity nodes are not supported");
                }
                case 7: {
                    throw new PluginNotSupportedException("Processing instruction nodes are not supported");
                }
                case 8: {
                    return new Comment(obj, doc);
                }
                case 9: {
                    return DOMObjectFactory.createHTMLElement(obj, (HTMLDocument)doc);
                }
                case 10: {
                    throw new PluginNotSupportedException("Document type nodes are not supported");
                }
                case 11: {
                    return new DocumentFragment(obj, doc);
                }
                case 12: {
                    throw new PluginNotSupportedException("Notation nodes are not supported");
                }
            }
            throw new PluginNotSupportedException("Unknown node type " + nodeType);
        }
        return null;
    }

    public static org.w3c.dom.html.HTMLElement createHTMLElement(Object obj, HTMLDocument doc) {
        if (obj == null || !(obj instanceof DOMObject)) {
            return null;
        }
        Class clazz = DOMObjectFactory.getRealClassByTagName((DOMObject)obj);
        if (clazz != null) {
            try {
                Class[] paramClasses = new Class[]{DOMObject.class, HTMLDocument.class};
                Constructor c = clazz.getConstructor(paramClasses);
                Object[] params = new Object[]{obj, doc};
                return (org.w3c.dom.html.HTMLElement)c.newInstance(params);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return new HTMLElement((DOMObject)obj, doc);
    }

    public static org.w3c.dom.html.HTMLFormElement createHTMLFormElement(Object obj, HTMLDocument doc) {
        org.w3c.dom.html.HTMLElement elem = DOMObjectFactory.createHTMLElement(obj, doc);
        if (elem != null && elem instanceof org.w3c.dom.html.HTMLFormElement) {
            return (org.w3c.dom.html.HTMLFormElement)elem;
        }
        return null;
    }

    public static org.w3c.dom.html.HTMLOptionElement createHTMLOptionElement(Object obj, HTMLDocument doc) {
        org.w3c.dom.html.HTMLElement elem = DOMObjectFactory.createHTMLElement(obj, doc);
        if (elem != null && elem instanceof org.w3c.dom.html.HTMLOptionElement) {
            return (org.w3c.dom.html.HTMLOptionElement)elem;
        }
        return null;
    }

    public static NodeList createNodeList(Object obj, HTMLDocument doc) {
        if (obj != null && obj instanceof DOMObject) {
            return new HTMLCollection((DOMObject)obj, doc);
        }
        return null;
    }

    public static org.w3c.dom.NamedNodeMap createNamedNodeMap(Object obj, HTMLDocument doc) {
        if (obj != null && obj instanceof DOMObject) {
            return new NamedNodeMap((DOMObject)obj, doc);
        }
        return null;
    }

    public static org.w3c.dom.html.HTMLCollection createHTMLCollection(Object obj, HTMLDocument doc) {
        return (org.w3c.dom.html.HTMLCollection)((Object)DOMObjectFactory.createNodeList(obj, doc));
    }

    public static org.w3c.dom.Attr createAttr(Object obj, Document doc) {
        if (obj != null && obj instanceof DOMObject) {
            return new Attr((DOMObject)obj, doc);
        }
        return null;
    }

    public static org.w3c.dom.stylesheets.StyleSheetList createStyleSheetList(Object obj, Document doc) {
        if (obj != null && obj instanceof DOMObject) {
            return new StyleSheetList((DOMObject)obj, doc);
        }
        return null;
    }

    public static org.w3c.dom.stylesheets.StyleSheet createStyleSheet(Object obj, Document doc) {
        if (obj != null && obj instanceof DOMObject) {
            return new StyleSheet((DOMObject)obj, doc);
        }
        return null;
    }

    public static org.w3c.dom.stylesheets.MediaList createMediaList(Object obj, Document doc) {
        if (obj != null && obj instanceof DOMObject) {
            return new MediaList((DOMObject)obj, doc);
        }
        return null;
    }

    public static org.w3c.dom.css.CSSStyleSheet createCSSStyleSheet(Object obj, Document doc) {
        if (obj != null && obj instanceof DOMObject) {
            return new CSSStyleSheet((DOMObject)obj, doc);
        }
        return null;
    }

    public static org.w3c.dom.css.CSSStyleDeclaration createCSSStyleDeclaration(Object obj, Document doc) {
        if (obj != null && obj instanceof DOMObject) {
            return new CSSStyleDeclaration((DOMObject)obj, doc);
        }
        return null;
    }

    public static org.w3c.dom.css.CSSValue createCSSValue(Object obj, Document doc) {
        if (obj != null && obj instanceof DOMObject) {
            try {
                Number number = (Number)((DOMObject)obj).getMember("cssValueType");
                switch (number.intValue()) {
                    case 0: 
                    case 3: {
                        return new CSSValue((DOMObject)obj, doc);
                    }
                    case 1: {
                        return new CSSPrimitiveValue((DOMObject)obj, doc);
                    }
                    case 2: {
                        return new CSSValueList((DOMObject)obj, doc);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static org.w3c.dom.css.CSSPrimitiveValue createCSSPrimitiveValue(Object obj, Document doc) {
        org.w3c.dom.css.CSSValue val = DOMObjectFactory.createCSSValue(obj, doc);
        if (val != null && val instanceof org.w3c.dom.css.CSSPrimitiveValue) {
            return (org.w3c.dom.css.CSSPrimitiveValue)val;
        }
        return null;
    }

    public static CSSRule createCSSRule(Object obj, Document doc) {
        if (obj != null && obj instanceof DOMObject) {
            try {
                DOMObject dobj = (DOMObject)obj;
                int ruleKind = ((Number)dobj.getMember("type")).intValue();
                switch (ruleKind) {
                    case 0: {
                        return new CSSUnknownRule(dobj, doc);
                    }
                    case 1: {
                        return new CSSStyleRule(dobj, doc);
                    }
                    case 2: {
                        return new CSSCharsetRule(dobj, doc);
                    }
                    case 3: {
                        return new CSSImportRule(dobj, doc);
                    }
                    case 4: {
                        return new CSSMediaRule(dobj, doc);
                    }
                    case 5: {
                        return new CSSFontFaceRule(dobj, doc);
                    }
                    case 6: {
                        return new CSSPageRule(dobj, doc);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static org.w3c.dom.css.CSSRuleList createCSSRuleList(Object obj, Document doc) {
        if (obj != null && obj instanceof DOMObject) {
            return new CSSRuleList((DOMObject)obj, doc);
        }
        return null;
    }

    public static org.w3c.dom.css.Counter createCSSCounter(Object obj) {
        if (obj != null && obj instanceof DOMObject) {
            return new Counter((DOMObject)obj);
        }
        return null;
    }

    public static org.w3c.dom.css.Rect createCSSRect(Object obj, Document document) {
        if (obj != null && obj instanceof DOMObject) {
            return new Rect((DOMObject)obj, document);
        }
        return null;
    }

    public static org.w3c.dom.css.RGBColor createCSSRGBColor(Object obj, Document document) {
        if (obj != null && obj instanceof DOMObject) {
            return new RGBColor((DOMObject)obj, document);
        }
        return null;
    }

    private static Class getRealClassByTagName(DOMObject obj) {
        try {
            Object result = obj.getMember("tagName");
            if (result != null) {
                return (Class)DOMObjectFactory.getElmTagClassMap().get(result);
            }
        }
        catch (DOMException dOMException) {
            // empty catch block
        }
        return null;
    }

    private static synchronized HashMap getElmTagClassMap() {
        if (elmTagClassMap == null) {
            elmTagClassMap = new HashMap();
            elmTagClassMap.put("A", HTMLAnchorElement.class);
            elmTagClassMap.put("APPLET", HTMLAppletElement.class);
            elmTagClassMap.put("AREA", HTMLAreaElement.class);
            elmTagClassMap.put("BASE", HTMLBaseElement.class);
            elmTagClassMap.put("BLOCKQUOTE", HTMLQuoteElement.class);
            elmTagClassMap.put("BODY", HTMLBodyElement.class);
            elmTagClassMap.put("BR", HTMLBRElement.class);
            elmTagClassMap.put("CAPTION", HTMLTableCaptionElement.class);
            elmTagClassMap.put("COL", HTMLTableColElement.class);
            elmTagClassMap.put("DEL", HTMLModElement.class);
            elmTagClassMap.put("DIR", HTMLDirectoryElement.class);
            elmTagClassMap.put("DIV", HTMLDivElement.class);
            elmTagClassMap.put("DL", HTMLDListElement.class);
            elmTagClassMap.put("FIELDSET", HTMLFieldSetElement.class);
            elmTagClassMap.put("FONT", HTMLFontElement.class);
            elmTagClassMap.put("FORM", HTMLFormElement.class);
            elmTagClassMap.put("FRAME", HTMLFrameElement.class);
            elmTagClassMap.put("FRAMESET", HTMLFrameSetElement.class);
            elmTagClassMap.put("HEAD", HTMLHeadElement.class);
            elmTagClassMap.put("H1", HTMLHeadingElement.class);
            elmTagClassMap.put("H2", HTMLHeadingElement.class);
            elmTagClassMap.put("H3", HTMLHeadingElement.class);
            elmTagClassMap.put("H4", HTMLHeadingElement.class);
            elmTagClassMap.put("H5", HTMLHeadingElement.class);
            elmTagClassMap.put("H6", HTMLHeadingElement.class);
            elmTagClassMap.put("HR", HTMLHRElement.class);
            elmTagClassMap.put("HTML", HTMLHtmlElement.class);
            elmTagClassMap.put("IFRAME", HTMLIFrameElement.class);
            elmTagClassMap.put("IMAGE", HTMLImageElement.class);
            elmTagClassMap.put("INPUT", HTMLInputElement.class);
            elmTagClassMap.put("INS", HTMLModElement.class);
            elmTagClassMap.put("ISINDEX", HTMLIsIndexElement.class);
            elmTagClassMap.put("LABEL", HTMLLabelElement.class);
            elmTagClassMap.put("LEGEND", HTMLLegendElement.class);
            elmTagClassMap.put("LI", HTMLLIElement.class);
            elmTagClassMap.put("LINK", HTMLLinkElement.class);
            elmTagClassMap.put("MAP", HTMLMapElement.class);
            elmTagClassMap.put("MENU", HTMLMenuElement.class);
            elmTagClassMap.put("META", HTMLMetaElement.class);
            elmTagClassMap.put("MOD", HTMLModElement.class);
            elmTagClassMap.put("OBJECT", HTMLObjectElement.class);
            elmTagClassMap.put("OL", HTMLOListElement.class);
            elmTagClassMap.put("OPTGROUP", HTMLOptGroupElement.class);
            elmTagClassMap.put("OPTION", HTMLOptionElement.class);
            elmTagClassMap.put("P", HTMLParagraphElement.class);
            elmTagClassMap.put("PARAM", HTMLParamElement.class);
            elmTagClassMap.put("PRE", HTMLPreElement.class);
            elmTagClassMap.put("Q", HTMLQuoteElement.class);
            elmTagClassMap.put("SCRIPT", HTMLScriptElement.class);
            elmTagClassMap.put("SELECT", HTMLSelectElement.class);
            elmTagClassMap.put("STYLE", HTMLStyleElement.class);
            elmTagClassMap.put("TABLE", HTMLTableElement.class);
            elmTagClassMap.put("TBODY", HTMLTableSectionElement.class);
            elmTagClassMap.put("TD", HTMLTableCellElement.class);
            elmTagClassMap.put("TFOOT", HTMLTableSectionElement.class);
            elmTagClassMap.put("TH", HTMLTableCellElement.class);
            elmTagClassMap.put("THEAD", HTMLTableSectionElement.class);
            elmTagClassMap.put("TR", HTMLTableRowElement.class);
            elmTagClassMap.put("TEXTAREA", HTMLTextAreaElement.class);
            elmTagClassMap.put("TITLE", HTMLTitleElement.class);
            elmTagClassMap.put("UL", HTMLUListElement.class);
            elmTagClassMap.put("ACRONYM", HTMLElement.class);
            elmTagClassMap.put("ABBR", HTMLElement.class);
            elmTagClassMap.put("ADDRESS", HTMLElement.class);
            elmTagClassMap.put("B", HTMLElement.class);
            elmTagClassMap.put("BDO", HTMLElement.class);
            elmTagClassMap.put("BIG", HTMLElement.class);
            elmTagClassMap.put("CITE", HTMLElement.class);
            elmTagClassMap.put("CENTER", HTMLElement.class);
            elmTagClassMap.put("CODE", HTMLElement.class);
            elmTagClassMap.put("DD", HTMLElement.class);
            elmTagClassMap.put("DFN", HTMLElement.class);
            elmTagClassMap.put("DT", HTMLElement.class);
            elmTagClassMap.put("EM", HTMLElement.class);
            elmTagClassMap.put("I", HTMLElement.class);
            elmTagClassMap.put("KBD", HTMLElement.class);
            elmTagClassMap.put("NOFRAMES", HTMLElement.class);
            elmTagClassMap.put("NOSCRIPT", HTMLElement.class);
            elmTagClassMap.put("S", HTMLElement.class);
            elmTagClassMap.put("SAMP", HTMLElement.class);
            elmTagClassMap.put("SMALL", HTMLElement.class);
            elmTagClassMap.put("SPAN", HTMLElement.class);
            elmTagClassMap.put("STRIKE", HTMLElement.class);
            elmTagClassMap.put("STRONG", HTMLElement.class);
            elmTagClassMap.put("SUB", HTMLElement.class);
            elmTagClassMap.put("SUP", HTMLElement.class);
            elmTagClassMap.put("U", HTMLElement.class);
            elmTagClassMap.put("VAR", HTMLElement.class);
        }
        return elmTagClassMap;
    }
}

