/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jnlp;

import com.sun.applet2.preloader.CancelException;
import com.sun.applet2.preloader.Preloader;
import com.sun.applet2.preloader.event.ConfigEvent;
import com.sun.applet2.preloader.event.InitEvent;
import com.sun.applet2.preloader.event.PreloaderEvent;
import com.sun.deploy.cache.Cache;
import com.sun.deploy.config.Config;
import com.sun.deploy.model.Resource;
import com.sun.deploy.model.ResourceProvider;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.deploy.uitoolkit.ToolkitStore;
import com.sun.javaws.CacheUtil;
import com.sun.javaws.LaunchDownload;
import com.sun.javaws.jnl.ExtensionDesc;
import com.sun.javaws.jnl.JARDesc;
import com.sun.javaws.jnl.LaunchDesc;
import com.sun.javaws.jnl.LaunchDescFactory;
import com.sun.javaws.jnl.ResourceVisitor;
import com.sun.javaws.jnl.ResourcesDesc;
import com.sun.javaws.progress.CustomProgress2PreloaderAdapter;
import com.sun.javaws.progress.PreloaderDelegate;
import com.sun.jnlp.JNLPClassLoaderIf;
import com.sun.jnlp.JNLPClassLoaderUtil;
import java.io.File;
import java.io.FilePermission;
import java.io.IOException;
import java.net.SocketPermission;
import java.net.URL;
import java.net.URLPermission;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;
import java.util.Arrays;
import java.util.jar.JarFile;
import javax.jnlp.DownloadService;
import javax.jnlp.DownloadServiceListener;

public final class DownloadServiceImpl
implements DownloadService {
    private static DownloadServiceImpl _sharedInstance = null;
    private DownloadServiceListener _defaultProgressHelper = null;
    private static final AccessControlContext ACC_DOWNLOAD_INSTANCE = AccessController.doPrivileged(new PrivilegedAction<AccessControlContext>(){

        @Override
        public AccessControlContext run() {
            Permissions permissions = new Permissions();
            ((PermissionCollection)permissions).add(new FilePermission("<<ALL FILES>>", "read,write,delete"));
            ((PermissionCollection)permissions).add(new SocketPermission("*", "connect,resolve"));
            ((PermissionCollection)permissions).add(new RuntimePermission("modifyThread"));
            ((PermissionCollection)permissions).add(new RuntimePermission("modifyThreadGroup"));
            if (Config.isJavaVersionAtLeast18()) {
                ((PermissionCollection)permissions).add(new URLPermission("http:*", "*:*"));
                ((PermissionCollection)permissions).add(new URLPermission("https:*", "*:*"));
            }
            return new AccessControlContext(new ProtectionDomain[]{new ProtectionDomain(null, permissions)});
        }
    });

    private DownloadServiceImpl() {
    }

    static synchronized void reset() {
        _sharedInstance = null;
    }

    public static synchronized DownloadServiceImpl getInstance() {
        DownloadServiceImpl.initialize();
        return _sharedInstance;
    }

    public static synchronized void initialize() {
        if (_sharedInstance == null) {
            _sharedInstance = new DownloadServiceImpl();
        }
    }

    @Override
    public DownloadServiceListener getDefaultProgressWindow() {
        if (this._defaultProgressHelper == null) {
            this._defaultProgressHelper = AccessController.doPrivileged(new PrivilegedAction<DownloadServiceListener>(){

                @Override
                public DownloadServiceListener run() {
                    Preloader preloader = ToolkitStore.get().getDefaultPreloader();
                    try {
                        preloader.handleEvent((PreloaderEvent)new ConfigEvent(3, JNLPClassLoaderUtil.getInstance().getLaunchDesc().getAppInfo()));
                        preloader.handleEvent((PreloaderEvent)new InitEvent(1));
                    }
                    catch (CancelException cancelException) {
                        Trace.ignoredException((Exception)((Object)cancelException));
                    }
                    return new PreloaderDelegate(preloader);
                }
            }, ACC_DOWNLOAD_INSTANCE);
        }
        return this._defaultProgressHelper;
    }

    @Override
    public boolean isResourceCached(final URL uRL, final String string) {
        Boolean bl = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                if (DownloadServiceImpl.this.isResourceValid(uRL, string) && ResourceProvider.get().isCached(uRL, string)) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
        }, ACC_DOWNLOAD_INSTANCE);
        return bl;
    }

    @Override
    public boolean isPartCached(String string) {
        return this.isPartCached(new String[]{string});
    }

    @Override
    public boolean isPartCached(final String[] stringArray) {
        Boolean bl = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                LaunchDesc launchDesc = JNLPClassLoaderUtil.getInstance().getLaunchDesc();
                ResourcesDesc resourcesDesc = launchDesc.getResources();
                if (resourcesDesc == null) {
                    return Boolean.FALSE;
                }
                JARDesc[] jARDescArray = resourcesDesc.getPartJars(stringArray);
                return DownloadServiceImpl.this.isJARInCache(jARDescArray, true);
            }
        }, ACC_DOWNLOAD_INSTANCE);
        return bl;
    }

    @Override
    public boolean isExtensionPartCached(URL uRL, String string, String string2) {
        return this.isExtensionPartCached(uRL, string, new String[]{string2});
    }

    @Override
    public boolean isExtensionPartCached(final URL uRL, final String string, final String[] stringArray) {
        Boolean bl = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                LaunchDesc launchDesc = JNLPClassLoaderUtil.getInstance().getLaunchDesc();
                ResourcesDesc resourcesDesc = launchDesc.getResources();
                if (resourcesDesc == null) {
                    return Boolean.FALSE;
                }
                JARDesc[] jARDescArray = resourcesDesc.getExtensionPart(uRL, string, stringArray);
                return DownloadServiceImpl.this.isJARInCache(jARDescArray, true);
            }
        }, ACC_DOWNLOAD_INSTANCE);
        return bl;
    }

    @Override
    public void loadResource(final URL uRL, final String string, final DownloadServiceListener downloadServiceListener) throws IOException {
        Trace.println((String)(this.getClass().getName() + ".loadResource(" + uRL + "," + downloadServiceListener.getClass().getName() + ")"));
        if (this.isResourceValid(uRL, string)) {
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                    @Override
                    public Void run() throws IOException {
                        CustomProgress2PreloaderAdapter customProgress2PreloaderAdapter = new CustomProgress2PreloaderAdapter(downloadServiceListener);
                        PreloaderDelegate preloaderDelegate = DownloadServiceImpl.this.getProgressHelper(customProgress2PreloaderAdapter);
                        ResourceProvider resourceProvider = ResourceProvider.get();
                        int n = resourceProvider.incrementInternalUse();
                        try {
                            JNLPClassLoaderIf jNLPClassLoaderIf = JNLPClassLoaderUtil.getInstance();
                            if (uRL.toString().endsWith(".jar")) {
                                if (string != null) {
                                    ToolkitStore.get().getAppContext().put((Object)("deploy-" + uRL.toString()), (Object)string);
                                }
                                jNLPClassLoaderIf.addResource(uRL, string, null);
                                if (!DownloadServiceImpl.this.isResourceCached(uRL, string)) {
                                    LaunchDownload.downloadResource(jNLPClassLoaderIf.getLaunchDesc(), uRL, string, preloaderDelegate, true);
                                }
                            } else {
                                Resource resource = resourceProvider.getResource(uRL, string);
                                if (resource.isJNLPFile()) {
                                    DownloadServiceImpl.this.loadResourceRecursivly(resource, downloadServiceListener);
                                } else if (resource.isJarFile()) {
                                    jNLPClassLoaderIf.addResource(uRL, string, null);
                                }
                            }
                        }
                        catch (Exception exception) {
                            throw new IOException(exception.getMessage());
                        }
                        finally {
                            preloaderDelegate.forceFlushForTCK();
                            resourceProvider.decrementInternalUse(n);
                        }
                        return null;
                    }
                }, ACC_DOWNLOAD_INSTANCE);
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw (IOException)privilegedActionException.getException();
            }
        }
    }

    private void loadResourceRecursivly(Resource resource, final DownloadServiceListener downloadServiceListener) {
        try {
            File file = new File(resource.getResourceFilename());
            URL uRL = new URL(resource.getURL());
            LaunchDesc launchDesc = LaunchDescFactory.buildDescriptor(file, null, null, uRL);
            ResourcesDesc resourcesDesc = launchDesc.getResources();
            if (resourcesDesc != null) {
                resourcesDesc.visit(new ResourceVisitor(){

                    @Override
                    public void visitJARDesc(JARDesc jARDesc) {
                        try {
                            DownloadServiceImpl.this.loadResource(jARDesc.getLocation(), jARDesc.getVersion(), downloadServiceListener);
                        }
                        catch (IOException iOException) {
                            Trace.ignored((Throwable)iOException);
                        }
                    }

                    @Override
                    public void visitExtensionDesc(ExtensionDesc extensionDesc) {
                        try {
                            DownloadServiceImpl.this.loadResource(extensionDesc.getLocation(), extensionDesc.getVersion(), downloadServiceListener);
                        }
                        catch (IOException iOException) {
                            Trace.ignored((Throwable)iOException);
                        }
                    }
                });
            }
        }
        catch (Exception exception) {
            Trace.ignored((Throwable)exception);
        }
    }

    @Override
    public void loadPart(String string, DownloadServiceListener downloadServiceListener) throws IOException {
        this.loadPart(new String[]{string}, downloadServiceListener);
    }

    @Override
    public void loadPart(final String[] stringArray, final DownloadServiceListener downloadServiceListener) throws IOException {
        Trace.println((String)(this.getClass().getName() + ".loadPart(" + Arrays.asList(stringArray) + "," + downloadServiceListener.getClass().getName() + ")"), (TraceLevel)TraceLevel.TEMP);
        if (this.isPartCached(stringArray)) {
            return;
        }
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws IOException {
                    CustomProgress2PreloaderAdapter customProgress2PreloaderAdapter = new CustomProgress2PreloaderAdapter(downloadServiceListener);
                    PreloaderDelegate preloaderDelegate = DownloadServiceImpl.this.getProgressHelper(customProgress2PreloaderAdapter);
                    try {
                        LaunchDownload.downloadParts(JNLPClassLoaderUtil.getInstance().getLaunchDesc(), stringArray, preloaderDelegate, true);
                    }
                    catch (Exception exception) {
                        throw new IOException(exception.getMessage());
                    }
                    finally {
                        preloaderDelegate.forceFlushForTCK();
                    }
                    return null;
                }
            }, ACC_DOWNLOAD_INSTANCE);
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (IOException)privilegedActionException.getException();
        }
    }

    @Override
    public void loadExtensionPart(URL uRL, String string, String string2, DownloadServiceListener downloadServiceListener) throws IOException {
        this.loadExtensionPart(uRL, string, new String[]{string2}, downloadServiceListener);
    }

    @Override
    public void loadExtensionPart(final URL uRL, final String string, final String[] stringArray, final DownloadServiceListener downloadServiceListener) throws IOException {
        try {
            Trace.println((String)(this.getClass().getName() + ".loadExtensionPart(" + Arrays.asList(stringArray) + "," + downloadServiceListener.getClass().getName() + ")"));
            AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws IOException {
                    CustomProgress2PreloaderAdapter customProgress2PreloaderAdapter = new CustomProgress2PreloaderAdapter(downloadServiceListener);
                    PreloaderDelegate preloaderDelegate = DownloadServiceImpl.this.getProgressHelper(customProgress2PreloaderAdapter);
                    try {
                        LaunchDownload.downloadExtensionPart(JNLPClassLoaderUtil.getInstance().getLaunchDesc(), uRL, string, stringArray, preloaderDelegate, true);
                    }
                    catch (Exception exception) {
                        throw new IOException(exception.getMessage());
                    }
                    finally {
                        preloaderDelegate.forceFlushForTCK();
                    }
                    return null;
                }
            }, ACC_DOWNLOAD_INSTANCE);
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (IOException)privilegedActionException.getException();
        }
    }

    @Override
    public void removeResource(final URL uRL, final String string) throws IOException {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws IOException {
                    if (DownloadServiceImpl.this.isResourceValid(uRL, string)) {
                        Resource resource;
                        if (uRL.toString().endsWith("jnlp")) {
                            CacheUtil.remove(Cache.getCacheEntry((URL)uRL, (String)string));
                        }
                        if ((resource = ResourceProvider.get().getCachedResource(uRL, string)) != null) {
                            ResourceProvider.get().markRetired(resource, true);
                        }
                    }
                    return null;
                }
            }, ACC_DOWNLOAD_INSTANCE);
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (IOException)privilegedActionException.getException();
        }
    }

    @Override
    public void removePart(String string) throws IOException {
        this.removePart(new String[]{string});
    }

    @Override
    public void removePart(final String[] stringArray) throws IOException {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws IOException {
                    LaunchDesc launchDesc = JNLPClassLoaderUtil.getInstance().getLaunchDesc();
                    ResourcesDesc resourcesDesc = launchDesc.getResources();
                    if (resourcesDesc == null) {
                        return null;
                    }
                    JARDesc[] jARDescArray = resourcesDesc.getPartJars(stringArray);
                    DownloadServiceImpl.this.removeJARFromCache(jARDescArray);
                    return null;
                }
            }, ACC_DOWNLOAD_INSTANCE);
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (IOException)privilegedActionException.getException();
        }
    }

    @Override
    public void removeExtensionPart(URL uRL, String string, String string2) throws IOException {
        this.removeExtensionPart(uRL, string, new String[]{string2});
    }

    @Override
    public void removeExtensionPart(final URL uRL, final String string, final String[] stringArray) throws IOException {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws IOException {
                    LaunchDesc launchDesc = JNLPClassLoaderUtil.getInstance().getLaunchDesc();
                    ResourcesDesc resourcesDesc = launchDesc.getResources();
                    if (resourcesDesc == null) {
                        return null;
                    }
                    JARDesc[] jARDescArray = resourcesDesc.getExtensionPart(uRL, string, stringArray);
                    DownloadServiceImpl.this.removeJARFromCache(jARDescArray);
                    return null;
                }
            }, ACC_DOWNLOAD_INSTANCE);
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (IOException)privilegedActionException.getException();
        }
    }

    private void removeJARFromCache(JARDesc[] jARDescArray) throws IOException {
        if (jARDescArray == null) {
            return;
        }
        if (jARDescArray.length == 0) {
            return;
        }
        for (JARDesc jARDesc : jARDescArray) {
            Resource resource = ResourceProvider.get().getCachedResource(jARDesc.getLocation(), jARDesc.getVersion());
            ResourceProvider.get().markRetired(resource, true);
        }
    }

    private boolean isJARInCache(JARDesc[] jARDescArray, boolean bl) {
        if (jARDescArray == null) {
            return false;
        }
        if (jARDescArray.length == 0) {
            return false;
        }
        boolean bl2 = true;
        for (JARDesc jARDesc : jARDescArray) {
            JarFile jarFile = ResourceProvider.get().getCachedJarFile(jARDesc.getLocation(), jARDesc.getVersion());
            if (jarFile != null) {
                if (bl) continue;
                return true;
            }
            bl2 = false;
        }
        return bl2;
    }

    private boolean isResourceValid(URL uRL, String string) {
        LaunchDesc launchDesc = JNLPClassLoaderUtil.getInstance().getLaunchDesc();
        JARDesc[] jARDescArray = launchDesc.getResources().getEagerOrAllJarDescs(true);
        if (launchDesc.getSecurityModel() != 0) {
            return true;
        }
        for (JARDesc jARDesc : jARDescArray) {
            if (!uRL.toString().equals(jARDesc.getLocation().toString()) || string != null && !string.equals(jARDesc.getVersion())) continue;
            return true;
        }
        URL uRL2 = launchDesc.getMainJarURL();
        return uRL2 != null && uRL != null && uRL.toString().startsWith(uRL2.toString());
    }

    private PreloaderDelegate getProgressHelper(CustomProgress2PreloaderAdapter customProgress2PreloaderAdapter) {
        return new PreloaderDelegate(customProgress2PreloaderAdapter);
    }
}

