/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaws.ui;

import com.sun.deploy.Environment;
import com.sun.deploy.net.DownloadException;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.deploy.ui.AppInfo;
import com.sun.deploy.uitoolkit.ToolkitStore;
import com.sun.deploy.uitoolkit.ui.ConsoleController;
import com.sun.deploy.uitoolkit.ui.ConsoleWindow;
import com.sun.deploy.util.DeploySysAction;
import com.sun.deploy.util.DeploySysRun;
import com.sun.javaws.Globals;
import com.sun.javaws.Main;
import com.sun.javaws.exceptions.ExitException;
import com.sun.javaws.exceptions.JNLPException;
import com.sun.javaws.jnl.LaunchDesc;
import com.sun.javaws.ui.SplashScreen;
import com.sun.javaws.util.JavawsConsoleController;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.security.GeneralSecurityException;

public class LaunchErrorDialog {
    private static String getMoreInfo(Throwable throwable) {
        Object object;
        Object object2;
        StringBuilder stringBuilder = new StringBuilder();
        String string = "<split>";
        JNLPException jNLPException = null;
        DownloadException downloadException = null;
        Throwable throwable2 = null;
        if (throwable instanceof JNLPException) {
            jNLPException = (JNLPException)throwable;
            throwable2 = jNLPException.getWrappedException();
        } else if (throwable instanceof DownloadException) {
            downloadException = (DownloadException)throwable;
            throwable2 = downloadException.getWrappedException();
        } else if (throwable instanceof ExitException) {
            throwable2 = ((ExitException)throwable).getException();
        }
        stringBuilder.append(LaunchErrorDialog.getErrorDescription(throwable));
        String string2 = null;
        String string3 = null;
        if (jNLPException != null) {
            string2 = jNLPException.getLaunchDescSource();
            if (string2 == null && (object2 = JNLPException.getDefaultLaunchDesc()) != null) {
                string2 = ((LaunchDesc)object2).getSource();
            }
        } else if (JNLPException.getDefaultLaunchDesc() != null) {
            string2 = JNLPException.getDefaultLaunchDesc().getSource();
        }
        if (JNLPException.getDefaultLaunchDesc() != null) {
            string3 = JNLPException.getDefaultLaunchDesc().getSource();
        }
        if (string3 != null && string3.equals(string2)) {
            string3 = null;
        }
        if (string2 != null) {
            stringBuilder.append(string);
            stringBuilder.append(ResourceManager.getString((String)"launcherrordialog.jnlpTab"));
            stringBuilder.append(string);
            stringBuilder.append(LaunchErrorDialog.filter(string2));
        }
        if (string3 != null) {
            stringBuilder.append(string);
            stringBuilder.append(ResourceManager.getString((String)"launcherrordialog.jnlpMainTab"));
            stringBuilder.append(string);
            stringBuilder.append(LaunchErrorDialog.filter(string3));
        }
        if (throwable != null) {
            object2 = new StringWriter();
            object = new PrintWriter((Writer)object2);
            throwable.printStackTrace((PrintWriter)object);
            stringBuilder.append(string);
            stringBuilder.append(ResourceManager.getString((String)"launcherrordialog.exceptionTab"));
            stringBuilder.append(string);
            stringBuilder.append(((StringWriter)object2).toString());
        }
        if (throwable2 != null) {
            object2 = new StringWriter();
            object = new PrintWriter((Writer)object2);
            throwable2.printStackTrace((PrintWriter)object);
            stringBuilder.append(string);
            stringBuilder.append(ResourceManager.getString((String)"launcherrordialog.wrappedExceptionTab"));
            stringBuilder.append(string);
            stringBuilder.append(((StringWriter)object2).toString());
        }
        object2 = JavawsConsoleController.getInstance();
        object = ToolkitStore.getUI().getConsole((ConsoleController)object2);
        ((JavawsConsoleController)object2).setConsole((ConsoleWindow)object);
        if (object != null) {
            stringBuilder.append(string);
            stringBuilder.append(ResourceManager.getString((String)"launcherrordialog.consoleTab"));
            try {
                stringBuilder.append(string);
                stringBuilder.append(object.getRecentLog());
            }
            catch (Exception exception) {
                Trace.ignored((Throwable)exception);
            }
        }
        return stringBuilder.toString();
    }

    private static String filter(String string) {
        if (string.length() > 10240) {
            return string.substring(0, 10239) + "\njnlp file truncated after 10K\n";
        }
        return string;
    }

    public static void show(final Object object, final Throwable throwable, boolean bl) {
        boolean bl2;
        SplashScreen.hide();
        System.err.println("#### Java Web Start Error:");
        System.err.println("#### " + LaunchErrorDialog.getMessage(throwable));
        if (Trace.isEnabled((TraceLevel)TraceLevel.BASIC)) {
            throwable.printStackTrace(System.err);
        }
        boolean bl3 = bl2 = !Globals.TCKHarnessRun && !Globals.isSilentMode();
        if (throwable instanceof ExitException && ((ExitException)throwable).getReason() == 0) {
            bl2 = false;
        }
        if (bl2) {
            DeploySysAction deploySysAction = new DeploySysAction(){

                public Object execute() {
                    Throwable throwable2 = throwable;
                    try {
                        ExitException exitException;
                        String string = null;
                        String string2 = LaunchErrorDialog.getErrorCategory(throwable);
                        if (throwable instanceof JNLPException) {
                            string = ((JNLPException)throwable).getBriefMessage();
                        } else if (throwable instanceof ExitException && (exitException = (ExitException)throwable).getReason() == 6) {
                            string = exitException.getMessage();
                            throwable2 = exitException.getException();
                        }
                        if (string == null) {
                            string = Environment.isImportMode() ? (Environment.isInstallMode() ? ResourceManager.getString((String)"launcherrordialog.uninstall.brief.message") : ResourceManager.getString((String)"launcherrordialog.import.brief.message")) : ResourceManager.getString((String)"launcherrordialog.brief.message");
                        }
                        exitException = LaunchErrorDialog.getLaunchDesc() == null ? new AppInfo() : LaunchErrorDialog.getLaunchDesc().getAppInfo();
                        exitException.setThrowable(throwable2);
                        String string3 = ResourceManager.getString((String)"launcherrordialog.brief.ok");
                        String string4 = ResourceManager.getString((String)"launcherrordialog.brief.details");
                        String string5 = ResourceManager.getString((String)"error.default.title", (Object[])new Object[]{string2});
                        ToolkitStore.getUI().showMessageDialog(object, (AppInfo)exitException, 0, string5, null, string, LaunchErrorDialog.getMoreInfo(throwable2), string3, string4, null);
                    }
                    catch (Exception exception) {
                        Trace.ignored((Throwable)exception);
                    }
                    return null;
                }
            };
            DeploySysRun.execute((DeploySysAction)deploySysAction, null);
        }
        if (bl) {
            try {
                Main.systemExit(-1);
            }
            catch (ExitException exitException) {
                Trace.println((String)("systemExit: " + exitException), (TraceLevel)TraceLevel.BASIC);
                Trace.ignoredException((Exception)exitException);
            }
        }
    }

    private static String getErrorCategory(Throwable throwable) {
        String string = ResourceManager.getString((String)"launch.error.category.unexpected");
        if (throwable instanceof JNLPException) {
            JNLPException jNLPException = (JNLPException)throwable;
            string = jNLPException.getCategory();
        } else if (throwable instanceof SecurityException || throwable instanceof GeneralSecurityException) {
            string = ResourceManager.getString((String)"launch.error.category.security");
        } else if (throwable instanceof OutOfMemoryError) {
            string = ResourceManager.getString((String)"launch.error.category.memory");
        } else if (throwable instanceof DownloadException) {
            string = ResourceManager.getString((String)"launch.error.category.download");
        }
        return string;
    }

    private static String getErrorDescription(Throwable throwable) {
        String string = LaunchErrorDialog.getMessage(throwable);
        if (string == null) {
            string = ResourceManager.getString((String)"launcherrordialog.genericerror", (Object[])new Object[]{throwable.getClass().getName()});
        }
        return string;
    }

    private static String getMessage(Throwable throwable) {
        if (throwable instanceof Exception) {
            if (throwable.getCause() != null) {
                return throwable.getMessage() + " from: " + throwable.getCause().getMessage();
            }
            return throwable.getMessage();
        }
        return throwable.getClass().getName() + ": " + throwable.getMessage();
    }

    private static LaunchDesc getLaunchDesc() {
        return JNLPException.getDefaultLaunchDesc();
    }
}

