/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jnlp;

import com.sun.deploy.cache.Cache;
import com.sun.deploy.config.Config;
import com.sun.deploy.config.Platform;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.util.URLUtil;
import com.sun.javaws.jnl.LaunchDesc;
import com.sun.jnlp.ApiDialog;
import com.sun.jnlp.CheckServicePermission;
import com.sun.jnlp.FileContentsImpl;
import com.sun.jnlp.JNLPClassLoaderUtil;
import com.sun.jnlp.PersistenceServiceNSBImpl;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilePermission;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;
import javax.jnlp.FileContents;
import javax.jnlp.PersistenceService;

public final class PersistenceServiceImpl
implements PersistenceService {
    private static final int MUFFIN_TAG_INDEX = 0;
    private static final int MUFFIN_MAXSIZE_INDEX = 1;
    private static final long GIGABYTE = 0x40000000L;
    private static final long GLOBAL_LIMIT = 0x100000000L;
    private static PersistenceService _sharedInstance = null;
    private static final AccessControlContext ACC_FILE_INSTANCE = AccessController.doPrivileged(new PrivilegedAction<AccessControlContext>(){

        @Override
        public AccessControlContext run() {
            Permissions perms = new Permissions();
            FilePermission perm = new FilePermission("<<ALL FILES>>", "read,write,delete");
            ((PermissionCollection)perms).add(perm);
            return new AccessControlContext(new ProtectionDomain[]{new ProtectionDomain(null, perms)});
        }
    });
    private long _appLimit = -1L;
    private final ApiDialog _apiDialog = new ApiDialog();

    private PersistenceServiceImpl() {
        long appLimit = (long)Config.getIntProperty((String)"deployment.javaws.muffin.max") * 1024L;
        if (appLimit > 0x100000000L) {
            appLimit = 0x100000000L;
        }
        this._appLimit = appLimit;
    }

    public static synchronized PersistenceService getInstance() {
        PersistenceServiceImpl.initialize();
        return _sharedInstance;
    }

    public static synchronized void initialize() {
        if (_sharedInstance == null) {
            _sharedInstance = Platform.get().isNativeSandbox() ? new PersistenceServiceNSBImpl(new PersistenceServiceImpl()) : new PersistenceServiceImpl();
        }
    }

    long getLength(URL url) throws MalformedURLException, IOException {
        this.checkAccess(url);
        return Cache.getMuffinSize((URL)url);
    }

    long getMaxLength(final URL url) throws MalformedURLException, IOException {
        long maxLen = 0L;
        try {
            maxLen = AccessController.doPrivileged(new PrivilegedExceptionAction<Long>(){

                @Override
                public Long run() throws IOException {
                    long[] longArray = Cache.getMuffinAttributes((URL)url);
                    if (longArray == null) {
                        return -1L;
                    }
                    return longArray[1];
                }
            }, ACC_FILE_INSTANCE);
        }
        catch (PrivilegedActionException e) {
            throw (IOException)e.getException();
        }
        return maxLen;
    }

    long setMaxLength(final URL url, long maxsize) throws MalformedURLException, IOException {
        long newmaxsize;
        block4: {
            newmaxsize = 0L;
            this.checkAccess(url);
            newmaxsize = this.checkSetMaxSize(url, maxsize);
            if (newmaxsize < 0L) {
                return -1L;
            }
            final long f_newmaxsize = newmaxsize;
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                    @Override
                    public Void run() throws MalformedURLException, IOException {
                        Cache.putMuffinAttributes((URL)url, (int)PersistenceServiceImpl.this.getTag(url), (long)f_newmaxsize);
                        return null;
                    }
                }, ACC_FILE_INSTANCE);
            }
            catch (PrivilegedActionException e) {
                Exception ee = e.getException();
                if (ee instanceof IOException) {
                    throw (IOException)ee;
                }
                if (!(ee instanceof MalformedURLException)) break block4;
                throw (MalformedURLException)ee;
            }
        }
        return newmaxsize;
    }

    private long checkSetMaxSize(final URL url, long maxsize) throws IOException {
        long allowedMaxSize;
        URL[] friendMuffins = null;
        try {
            friendMuffins = AccessController.doPrivileged(new PrivilegedExceptionAction<URL[]>(){

                @Override
                public URL[] run() throws IOException {
                    return Cache.getAccessibleMuffins((URL)url);
                }
            }, ACC_FILE_INSTANCE);
        }
        catch (PrivilegedActionException e) {
            throw (IOException)e.getException();
        }
        long friendMuffinsTotalMaxSize = 0L;
        if (friendMuffins != null) {
            for (URL friendMuffin1 : friendMuffins) {
                URL friendMuffin;
                if (friendMuffin1 == null || (friendMuffin = friendMuffin1).equals(url)) continue;
                long friendMuffinsSize = 0L;
                try {
                    friendMuffinsSize = this.getMaxLength(friendMuffin);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                friendMuffinsTotalMaxSize += friendMuffinsSize;
            }
        }
        if (maxsize > (allowedMaxSize = this._appLimit - friendMuffinsTotalMaxSize)) {
            return this.reconcileMaxSize(maxsize, friendMuffinsTotalMaxSize, this._appLimit);
        }
        return maxsize;
    }

    private long reconcileMaxSize(long maxsize, long friendMuffinsTotalMaxSize, long appLimit) {
        long requestedSize = maxsize + friendMuffinsTotalMaxSize;
        if (requestedSize < maxsize || requestedSize > 0x100000000L) {
            return appLimit - friendMuffinsTotalMaxSize;
        }
        boolean unrestricted = CheckServicePermission.hasFileAccessPermissions();
        if (unrestricted || this.askUser(requestedSize, appLimit)) {
            this._appLimit = requestedSize;
            return maxsize;
        }
        return appLimit - friendMuffinsTotalMaxSize;
    }

    public long create(final URL url, long maxsize) throws MalformedURLException, IOException {
        long l;
        block4: {
            this.checkAccess(url);
            l = 0L;
            long newmaxsize = -1L;
            newmaxsize = this.checkSetMaxSize(url, maxsize);
            if (newmaxsize < 0L) {
                return 0L;
            }
            final long pass_newmaxsize = newmaxsize;
            try {
                l = AccessController.doPrivileged(new PrivilegedExceptionAction<Long>(){

                    @Override
                    public Long run() throws MalformedURLException, IOException {
                        Cache.createMuffinEntry((URL)url, (int)0, (long)pass_newmaxsize);
                        return pass_newmaxsize;
                    }
                }, ACC_FILE_INSTANCE);
            }
            catch (PrivilegedActionException e) {
                Exception ee = e.getException();
                if (ee instanceof IOException) {
                    throw (IOException)ee;
                }
                if (!(ee instanceof MalformedURLException)) break block4;
                throw (MalformedURLException)ee;
            }
        }
        return l;
    }

    public FileContents get(final URL url) throws MalformedURLException, IOException {
        File f;
        block4: {
            this.checkAccess(url);
            f = null;
            try {
                f = AccessController.doPrivileged(new PrivilegedExceptionAction<File>(){

                    @Override
                    public File run() throws MalformedURLException, IOException {
                        return Cache.getMuffinFile((URL)url);
                    }
                }, ACC_FILE_INSTANCE);
            }
            catch (PrivilegedActionException e) {
                Exception ee = e.getException();
                if (ee instanceof IOException) {
                    throw (IOException)ee;
                }
                if (!(ee instanceof MalformedURLException)) break block4;
                throw (MalformedURLException)ee;
            }
        }
        if (f == null) {
            throw new FileNotFoundException(url.toString());
        }
        return new FileContentsImpl(f, this, url, this.getMaxLength(url));
    }

    String get(String urlString) throws MalformedURLException, IOException {
        File f;
        URL url;
        block4: {
            url = new URL(urlString);
            this.checkAccess(url);
            f = null;
            try {
                f = AccessController.doPrivileged(new PrivilegedExceptionAction<File>(){

                    @Override
                    public File run() throws MalformedURLException, IOException {
                        return Cache.getMuffinFile((URL)url);
                    }
                }, ACC_FILE_INSTANCE);
            }
            catch (PrivilegedActionException e) {
                Exception ee = e.getException();
                if (ee instanceof IOException) {
                    throw (IOException)ee;
                }
                if (!(ee instanceof MalformedURLException)) break block4;
                throw (MalformedURLException)ee;
            }
        }
        if (f == null) {
            throw new FileNotFoundException(url.toString());
        }
        return f.getAbsolutePath();
    }

    public void delete(final URL url) throws MalformedURLException, IOException {
        block3: {
            this.checkAccess(url);
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                    @Override
                    public Void run() throws MalformedURLException, IOException {
                        Cache.removeMuffinEntry((URL)url);
                        return null;
                    }
                }, ACC_FILE_INSTANCE);
            }
            catch (PrivilegedActionException e) {
                Exception ee = e.getException();
                if (ee instanceof IOException) {
                    throw (IOException)ee;
                }
                if (!(ee instanceof MalformedURLException)) break block3;
                throw (MalformedURLException)ee;
            }
        }
    }

    public String[] getNames(URL url) throws MalformedURLException, IOException {
        String[] s;
        block3: {
            s = null;
            final URL pathUrl = URLUtil.asPathURL((URL)url);
            this.checkAccess(pathUrl);
            try {
                s = AccessController.doPrivileged(new PrivilegedExceptionAction<String[]>(){

                    @Override
                    public String[] run() throws MalformedURLException, IOException {
                        return Cache.getMuffinNames((URL)pathUrl);
                    }
                }, ACC_FILE_INSTANCE);
            }
            catch (PrivilegedActionException e) {
                Exception ee = e.getException();
                if (ee instanceof IOException) {
                    throw (IOException)ee;
                }
                if (!(ee instanceof MalformedURLException)) break block3;
                throw (MalformedURLException)ee;
            }
        }
        return s;
    }

    public int getTag(final URL url) throws MalformedURLException, IOException {
        Integer i;
        block3: {
            i = null;
            this.checkAccess(url);
            try {
                i = AccessController.doPrivileged(new PrivilegedExceptionAction<Integer>(){

                    @Override
                    public Integer run() throws MalformedURLException, IOException {
                        long[] attributes = Cache.getMuffinAttributes((URL)url);
                        if (attributes == null) {
                            throw new MalformedURLException();
                        }
                        return (int)attributes[0];
                    }
                }, ACC_FILE_INSTANCE);
            }
            catch (PrivilegedActionException e) {
                Exception ee = e.getException();
                if (ee instanceof IOException) {
                    throw (IOException)ee;
                }
                if (!(ee instanceof MalformedURLException)) break block3;
                throw (MalformedURLException)ee;
            }
        }
        return i;
    }

    public void setTag(final URL url, final int tag) throws MalformedURLException, IOException {
        block3: {
            this.checkAccess(url);
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                    @Override
                    public Void run() throws MalformedURLException, IOException {
                        Cache.putMuffinAttributes((URL)url, (int)tag, (long)PersistenceServiceImpl.this.getMaxLength(url));
                        return null;
                    }
                }, ACC_FILE_INSTANCE);
            }
            catch (PrivilegedActionException e) {
                Exception ee = e.getException();
                if (ee instanceof IOException) {
                    throw (IOException)ee;
                }
                if (!(ee instanceof MalformedURLException)) break block3;
                throw (MalformedURLException)ee;
            }
        }
    }

    private boolean askUser(final long requested, final long currentLimit) {
        Boolean bb = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                String title = ResourceManager.getString((String)"api.persistence.title");
                String msg = ResourceManager.getString((String)"api.persistence.message");
                String detail = ResourceManager.getString((String)"api.persistence.detail", (Object[])new Object[]{requested, currentLimit});
                ApiDialog.DialogResult result = PersistenceServiceImpl.this._apiDialog.askUser(title, msg, null, null, detail, false);
                if (result == ApiDialog.DialogResult.OK || result == ApiDialog.DialogResult.ALWAYS) {
                    long value = Math.min(0x100000000L, (requested + 1023L) / 1024L);
                    Config.setIntProperty((String)"deployment.javaws.muffin.max", (int)((int)value));
                    Config.get().storeIfNeeded();
                    return true;
                }
                return false;
            }
        }, ACC_FILE_INSTANCE);
        return bb;
    }

    protected void checkAccess(URL url) throws MalformedURLException {
        URL mainJarURL;
        if (url == null) {
            throw new MalformedURLException("URL is null");
        }
        LaunchDesc ld = JNLPClassLoaderUtil.getInstance().getLaunchDesc();
        if (ld != null && ld.getSecurityModel() == 0 && (mainJarURL = ld.getMainJarURL()) != null) {
            int idx;
            String file;
            if (url == null || !mainJarURL.getHost().equals(url.getHost())) {
                this.throwAccessDenied(url);
            }
            if ((file = url.getFile()) == null) {
                this.throwAccessDenied(url);
            }
            if ((idx = file.lastIndexOf(47)) == -1) {
                return;
            }
            if (!mainJarURL.getFile().startsWith(file.substring(0, idx + 1))) {
                this.throwAccessDenied(url);
            }
        }
    }

    private void throwAccessDenied(URL url) throws MalformedURLException {
        throw new MalformedURLException(ResourceManager.getString((String)"api.persistence.accessdenied", (Object[])new Object[]{url.toString()}));
    }
}

