/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.util;

import java.security.AccessController;
import java.security.PrivilegedAction;

public class SystemPropertyUtil {
    public static String getProperty(String string, String string2) {
        return AccessController.doPrivileged(new DeployGetPropertyAction(string, string2));
    }

    public static String getProperty(String string) {
        return AccessController.doPrivileged(new DeployGetPropertyAction(string));
    }

    public static Integer getIntProperty(String string, int n) {
        return AccessController.doPrivileged(new DeployGetIntegerAction(string, n));
    }

    public static Integer getIntProperty(String string) {
        return AccessController.doPrivileged(new DeployGetIntegerAction(string));
    }

    public static Boolean getBooleanProperty(String string) {
        return AccessController.doPrivileged(new DeployGetBooleanAction(string));
    }

    private static class DeployGetBooleanAction
    implements PrivilegedAction<Boolean> {
        private String theProp;

        public DeployGetBooleanAction(String string) {
            this.theProp = string;
        }

        @Override
        public Boolean run() {
            return Boolean.getBoolean(this.theProp);
        }
    }

    private static class DeployGetIntegerAction
    implements PrivilegedAction<Integer> {
        private String theProp;
        private int defaultVal;
        private boolean defaultSet = false;

        public DeployGetIntegerAction(String string) {
            this.theProp = string;
        }

        public DeployGetIntegerAction(String string, int n) {
            this.theProp = string;
            this.defaultVal = n;
            this.defaultSet = true;
        }

        @Override
        public Integer run() {
            Integer n = Integer.getInteger(this.theProp);
            if (n == null && this.defaultSet) {
                return this.defaultVal;
            }
            return n;
        }
    }

    private static class DeployGetPropertyAction
    implements PrivilegedAction<String> {
        private String theProp;
        private String defaultVal;

        public DeployGetPropertyAction(String string) {
            this.theProp = string;
        }

        public DeployGetPropertyAction(String string, String string2) {
            this.theProp = string;
            this.defaultVal = string2;
        }

        @Override
        public String run() {
            String string = System.getProperty(this.theProp);
            return string == null ? this.defaultVal : string;
        }
    }
}

