/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.util;

import com.sun.deploy.Environment;
import com.sun.deploy.config.Config;
import com.sun.deploy.config.JREInfo;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.deploy.util.ArgumentParsingUtil;
import com.sun.deploy.util.JVMParameterConverter;
import com.sun.deploy.util.Property;
import com.sun.deploy.util.StringUtils;
import com.sun.deploy.util.SystemUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public final class JVMParameters {
    private static final boolean DEBUG = false;
    private static final Map<String, String> knownDefaultValues = new HashMap<String, String>();
    private final List<String> internalArguments = new ArrayList<String>();
    private final ArgumentSet trustedArguments = new ArgumentSet();
    private final ArgumentSet arguments = new ArgumentSet();
    private long maxHeap = 0L;
    private boolean isDefault;
    private boolean isHtmlJavaArguments;
    private boolean includeExtendedASCIIValues;
    private static final long DEFAULT_HEAP = 0x4000000L;
    private static final String INTERNAL_SEPARATOR_ARG = "---";
    private static final String TRUSTED_SEPARATOR_ARG = "--";
    private static JVMParameters runningJVMParameters;
    private static final String[] PLUGIN_DEPENDENT_JARS;
    private static final long[] MEMSIZES;

    public JVMParameters() {
        this.clear();
    }

    public boolean isEmpty() {
        return this.internalArguments.isEmpty() && this.trustedArguments.size() == 0 && this.arguments.size() == 0;
    }

    public void clear() {
        this.internalArguments.clear();
        this.clearUserArguments();
    }

    public void clearUserArguments() {
        this.trustedArguments.clear();
        this.arguments.clear();
        this.maxHeap = 0L;
        this.isDefault = true;
    }

    public JVMParameters copy() {
        JVMParameters jVMParameters = new JVMParameters();
        jVMParameters.addArguments(this);
        return jVMParameters;
    }

    public JVMParameters copy(JVMParameterConverter jVMParameterConverter) {
        JVMParameters jVMParameters = new JVMParameters();
        jVMParameters.addArguments(this, jVMParameterConverter);
        return jVMParameters;
    }

    public String[][] copyToStringArrays() {
        String[][] stringArray = new String[8][];
        stringArray[0] = this.internalArguments.toArray(new String[0]);
        this.trustedArguments.copyToStringArrays(stringArray, 1);
        String[] stringArray2 = new String[]{this.getXmx()};
        stringArray[4] = stringArray2;
        this.arguments.copyToStringArrays(stringArray, 5);
        return stringArray;
    }

    public void getFromStringArrays(String[][] stringArray) {
        this.internalArguments.addAll(Arrays.asList(stringArray[0]));
        this.trustedArguments.getFromStringArrays(stringArray, 1);
        String string = stringArray[4][0];
        if (string != null) {
            this.addArgument(string);
        }
        this.arguments.getFromStringArrays(stringArray, 5);
        this.recomputeIsDefault();
    }

    public void parse(String string) {
        this.parseImpl(string, false, false);
    }

    public void parse(String string, boolean bl) {
        this.parseImpl(string, false, bl);
    }

    public void parseTrustedOptions(String string) {
        this.parseImpl(string, true, false);
    }

    private void parseImpl(String string, boolean bl, boolean bl2) {
        List<String> list;
        if (string == null) {
            return;
        }
        try {
            list = ArgumentParsingUtil.parseCommandLine(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            System.out.println(illegalArgumentException.getMessage());
            return;
        }
        boolean bl3 = true;
        Iterator<String> iterator = list.iterator();
        while (iterator.hasNext()) {
            String string2;
            String string3 = string2 = iterator.next();
            bl3 = this.addArgumentImpl(string3, bl3, bl, bl2);
        }
    }

    public void addProperties(Properties properties) {
        this.arguments.addAll(properties);
        this.recomputeIsDefault();
    }

    public void addProperties(List<Property> list) {
        this.arguments.addAll(list);
        this.recomputeIsDefault();
    }

    public void addEncodedArguments(String string, boolean bl, boolean bl2, boolean bl3) {
        List<String> list = ArgumentParsingUtil.decodeArgumentList(string);
        if (list != null && !list.isEmpty()) {
            Iterator<String> iterator = list.iterator();
            while (iterator.hasNext()) {
                String string2;
                String string3 = string2 = iterator.next();
                if (bl2) {
                    string3 = ArgumentParsingUtil.unquoteIfNeeded(string3);
                }
                this.addArgumentImpl(string3, true, bl, bl3);
            }
        }
    }

    public void addArgument(String string) {
        this.addArgument(string, true);
    }

    public void addArgument(String string, boolean bl) {
        this.addArgumentImpl(string, bl, false, false);
    }

    public void addInternalArgument(String string) {
        this.internalArguments.add(string);
    }

    public void addArguments(JVMParameters jVMParameters) {
        if (jVMParameters == null) {
            return;
        }
        this.internalArguments.addAll(jVMParameters.internalArguments);
        this.trustedArguments.addAll(jVMParameters.trustedArguments);
        this.arguments.addAll(jVMParameters.arguments);
        if (!jVMParameters.isDefault && jVMParameters.maxHeap > 0L) {
            this.maxHeap = jVMParameters.maxHeap;
        } else if (this.isDefault && jVMParameters.isDefault) {
            this.maxHeap = this.maxHeap != 0L || jVMParameters.maxHeap != 0L ? Math.max(this.getMaxHeapSize(), jVMParameters.getMaxHeapSize()) : 0L;
        } else if (0L == this.maxHeap) {
            this.maxHeap = jVMParameters.maxHeap;
        }
        this.isDefault = this.isDefault && jVMParameters.isDefault;
    }

    public void addArguments(JVMParameters jVMParameters, JVMParameterConverter jVMParameterConverter) {
        if (jVMParameters == null) {
            return;
        }
        for (String string : this.internalArguments) {
            String string2 = jVMParameterConverter.convert(string);
            if (string2 == null) continue;
            this.internalArguments.add(string2);
        }
        this.trustedArguments.addAll(jVMParameters.trustedArguments, jVMParameterConverter);
        this.arguments.addAll(jVMParameters.arguments, jVMParameterConverter);
    }

    public void removeArgument(String string) {
        if (string.startsWith("-Xmx")) {
            this.maxHeap = 0L;
        } else if (!this.trustedArguments.removeArgument(string)) {
            this.arguments.removeArgument(string);
        }
        this.recomputeIsDefault();
    }

    public void parseBootClassPath(String[] stringArray) {
        String string = SystemUtils.priviledgedGetSystemProperty("sun.boot.class.path");
        String string2 = System.getProperty("java.home");
        this.parseBootClassPath(string, string2, stringArray);
    }

    private void parseBootClassPath(String string, String string2, String[] stringArray) {
        if (stringArray != null && stringArray.length > 0) {
            String string3 = null;
            String string4 = Environment.getForcedDeployRoot();
            String string5 = Environment.getForcedBootClassPath();
            if (string4 != null) {
                for (String string6 : stringArray) {
                    String string7 = string4 + File.separator + "lib" + File.separator + string6;
                    string3 = string3 == null ? string7 : string3 + File.pathSeparator + string7;
                }
                if (string3 != null) {
                    this.addInternalArgument("-Xbootclasspath/a:" + string3);
                }
            } else if (string5 != null) {
                this.addInternalArgument("-Xbootclasspath/p:" + string5);
            } else if (string != null) {
                String[] stringArray2;
                try {
                    stringArray2 = string.split(File.pathSeparator);
                }
                catch (NoSuchMethodError noSuchMethodError) {
                    stringArray2 = StringUtils.splitString(string, File.pathSeparator);
                }
                block3: for (String string8 : stringArray2) {
                    for (String string9 : stringArray) {
                        if (!string8.endsWith(string9)) continue;
                        if (string3 == null) {
                            string3 = string8;
                            continue block3;
                        }
                        string3 = string3 + File.pathSeparator + string8;
                        continue block3;
                    }
                }
                if (string3 != null) {
                    this.addInternalArgument("-Xbootclasspath/a:" + string3);
                }
            } else if (string2 != null) {
                for (String string10 : stringArray) {
                    String string11 = string2 + File.separator + "lib" + File.separator + string10;
                    string3 = string3 == null ? string11 : string3 + File.pathSeparator + string11;
                }
                if (string3 != null) {
                    this.addInternalArgument("-Xbootclasspath/a:" + string3);
                }
            }
        }
    }

    public static String[] getPlugInDependentJars() {
        return (String[])PLUGIN_DEPENDENT_JARS.clone();
    }

    public List<String> getCommandLineArguments(JREInfo jREInfo, boolean bl) {
        return this.getCommandLineArguments(jREInfo, bl, true, true, true, false);
    }

    public List<String> getCommandLineArguments(JREInfo jREInfo, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        String string;
        ArrayList<String> arrayList = new ArrayList<String>();
        if (bl2) {
            boolean bl6 = jREInfo != null ? jREInfo.isModularJRE() : false;
            for (String string2 : this.internalArguments) {
                if (bl6) {
                    if (bl5) {
                        if (string2.startsWith("-Xbootclasspath/a") || string2.startsWith("-Djava.class.path")) continue;
                        arrayList.add(string2);
                        continue;
                    }
                    if (string2.startsWith("-Xbootclasspath/a")) continue;
                    arrayList.add(string2);
                    continue;
                }
                if (bl5) {
                    if (string2.startsWith("-Xbootclasspath/a") || string2.startsWith("-Djava.class.path")) continue;
                    arrayList.add(string2);
                    continue;
                }
                arrayList.add(string2);
            }
        }
        if (bl) {
            arrayList.add(INTERNAL_SEPARATOR_ARG);
        }
        if (bl3) {
            this.trustedArguments.addTo(arrayList, bl4);
        }
        if (bl) {
            arrayList.add(TRUSTED_SEPARATOR_ARG);
        }
        if ((string = this.getXmx()) != null) {
            arrayList.add(string);
        }
        this.arguments.addTo(arrayList, bl4);
        this.ensureNoDuplicates(arrayList);
        return arrayList;
    }

    private void ensureNoDuplicates(List<String> list) {
        HashSet<String> hashSet = new HashSet<String>();
        Iterator<String> iterator = list.iterator();
        while (iterator.hasNext()) {
            String string = iterator.next();
            if (hashSet.contains(string)) {
                iterator.remove();
                continue;
            }
            hashSet.add(string);
        }
    }

    public String getEncodedArguments(boolean bl) {
        List<String> list = this.getCommandLineArguments(null, false, false, bl, !bl, false);
        return ArgumentParsingUtil.encodeArgumentList(list);
    }

    public void addTo(Properties properties) {
        this.trustedArguments.addTo(properties);
        this.arguments.addTo(properties);
    }

    public Properties getProperties() {
        Properties properties = new Properties();
        this.addTo(properties);
        return properties;
    }

    public void setDefault(boolean bl) {
        this.isDefault = bl;
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    public void setHtmlJavaArgs(boolean bl) {
        this.isHtmlJavaArguments = bl;
    }

    public boolean isHtmlJavaArgs() {
        return this.isHtmlJavaArguments;
    }

    public void setIncludeExtendedASCIIValues(boolean bl) {
        this.includeExtendedASCIIValues = bl;
    }

    public boolean satisfies(JVMParameters jVMParameters) {
        if (jVMParameters == null) {
            return false;
        }
        if (this.getMaxHeapSize() < jVMParameters.getMaxHeapSize()) {
            return false;
        }
        if (this.isDefault && jVMParameters.isDefault) {
            return true;
        }
        if (this.isSecure() != jVMParameters.isSecure()) {
            return false;
        }
        if (!this.isDefault && jVMParameters.isDefault) {
            return false;
        }
        int n = jVMParameters.size();
        for (int i = 0; i < n; ++i) {
            String string = jVMParameters.get(i);
            if (this.isExcluded(string) || this.contains(string)) continue;
            return false;
        }
        return !this.isHtmlJavaArgs() || this.size() == n;
    }

    public boolean satisfiesSecure(JVMParameters jVMParameters) {
        if (jVMParameters == null) {
            return false;
        }
        if (this.getMaxHeapSize() < jVMParameters.getMaxHeapSize()) {
            return false;
        }
        if (this.isDefault && jVMParameters.isDefault) {
            return true;
        }
        if (!this.isDefault && jVMParameters.isDefault) {
            return false;
        }
        int n = jVMParameters.size();
        for (int i = 0; i < n; ++i) {
            String string = jVMParameters.get(i);
            if (!JVMParameters.isSecureArgument(string) || this.isExcluded(string) || this.contains(string)) continue;
            return false;
        }
        return true;
    }

    private static boolean isSecureArgument(String string) {
        Property property = Property.createProperty(string);
        if (property != null) {
            return property.isSecure();
        }
        return Config.isSecureVmArg(string);
    }

    public static boolean isJVMCommandLineArgument(String string) {
        if (string == null) {
            return false;
        }
        return string.charAt(0) == '-';
    }

    public long getMaxHeapSize() {
        return this.maxHeap > 0L ? this.maxHeap : JVMParameters.getDefaultHeapSize();
    }

    public void setMaxHeapSize(long l) {
        if (l > 0L) {
            this.maxHeap = l;
        }
        if (this.maxHeap > 0L && this.maxHeap != JVMParameters.getDefaultHeapSize()) {
            this.isDefault = false;
        }
    }

    public static final long getDefaultHeapSize() {
        if (runningJVMParameters == null || !runningJVMParameters.isDefault()) {
            return 0x4000000L;
        }
        try {
            long l = Runtime.getRuntime().maxMemory();
            long l2 = JVMParameters.snapToKnownMemorySize(l);
            if (l2 > 0L) {
                return l2;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return 0x4000000L;
    }

    static long snapToKnownMemorySize(long l) {
        if (l < 0L) {
            return 0L;
        }
        long l2 = Math.max(l / 10L, 0x1000000L);
        for (int i = 0; i < MEMSIZES.length; ++i) {
            if (Math.abs(l - MEMSIZES[i]) >= l2) continue;
            return MEMSIZES[i];
        }
        return 0L;
    }

    public static JVMParameters getRunningJVMParameters() {
        return runningJVMParameters;
    }

    public static void setRunningJVMParameters(JVMParameters jVMParameters) {
        runningJVMParameters = new JVMParameters();
        Properties properties = new Properties();
        Config.addSecureSystemPropertiesTo(properties);
        runningJVMParameters.addProperties(properties);
        runningJVMParameters.addArguments(jVMParameters);
        if (jVMParameters != null) {
            runningJVMParameters.setHtmlJavaArgs(jVMParameters.isHtmlJavaArgs());
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("[JVMParameters: isSecure: " + this.isSecure() + ", args:");
        List<String> list = this.getCommandLineArguments(null, false);
        stringBuilder.append(ArgumentParsingUtil.serializeArgumentListForDebugging(list));
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    public boolean contains(String string) {
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            if (!string.equals(this.get(i))) continue;
            return true;
        }
        return false;
    }

    public boolean isExcluded(String string) {
        return Property.isJnlpProperty(string);
    }

    public boolean containsPrefix(String string) {
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            if (!this.get(i).startsWith(string)) continue;
            return true;
        }
        return false;
    }

    public boolean isSecure() {
        return this.arguments.isSecure();
    }

    public static long parseMemorySpec(String string) throws IllegalArgumentException {
        long l = 1L;
        String string2 = string;
        for (int i = 0; i < string.length(); ++i) {
            if (Character.isDigit(string.charAt(i))) continue;
            if (i != string.length() - 1) {
                throw new IllegalArgumentException("Too many characters after heap size specifier: " + string);
            }
            switch (string.charAt(i)) {
                case 'T': 
                case 't': {
                    l = 0x10000000000L;
                    break;
                }
                case 'G': 
                case 'g': {
                    l = 0x40000000L;
                    break;
                }
                case 'M': 
                case 'm': {
                    l = 0x100000L;
                    break;
                }
                case 'K': 
                case 'k': {
                    l = 1024L;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Illegal heap size specifier " + string.charAt(i) + " in " + string2);
                }
            }
            string = string.substring(0, string.length() - 1);
            break;
        }
        try {
            return Long.parseLong(string) * l;
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException(numberFormatException);
        }
    }

    public static String unparseMemorySpec(long l) {
        if (l % 0x10000000000L == 0L) {
            return Long.toString(l / 0x10000000000L) + "t";
        }
        if (l % 0x40000000L == 0L) {
            return Long.toString(l / 0x40000000L) + "g";
        }
        if (l % 0x100000L == 0L) {
            return Long.toString(l / 0x100000L) + "m";
        }
        if (l % 1024L == 0L) {
            return Long.toString(l / 1024L) + "k";
        }
        return Long.toString(l);
    }

    private boolean addArgumentImpl(String string, boolean bl, boolean bl2, boolean bl3) {
        boolean bl4;
        if (bl && string.startsWith("-Xmx")) {
            try {
                this.maxHeap = JVMParameters.parseMemorySpec(string.substring("-Xmx".length()));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            bl4 = true;
        } else {
            bl4 = bl2 ? this.trustedArguments.addArgument(string, bl, this.includeExtendedASCIIValues) : (bl3 ? (Config.isSecureVmArg(string) || Config.isSecureSystemProperty(string) ? this.arguments.addArgument(string, bl, this.includeExtendedASCIIValues) : true) : this.arguments.addArgument(string, bl, this.includeExtendedASCIIValues));
        }
        this.recomputeIsDefault();
        return bl4;
    }

    private String getXmx() {
        if (this.getMaxHeapSize() != JVMParameters.getDefaultHeapSize()) {
            return "-Xmx" + JVMParameters.unparseMemorySpec(this.maxHeap);
        }
        return null;
    }

    private void recomputeIsDefault() {
        this.isDefault = this.getMaxHeapSize() == JVMParameters.getDefaultHeapSize() && this.arguments.isDefault();
    }

    private int size() {
        return this.trustedArguments.size() + this.arguments.size();
    }

    private String get(int n) {
        if (n < this.trustedArguments.size()) {
            return this.trustedArguments.get(n);
        }
        return this.arguments.get(n -= this.trustedArguments.size());
    }

    static {
        knownDefaultValues.put("sun.awt.enableExtraMouseButtons", "true");
        runningJVMParameters = null;
        PLUGIN_DEPENDENT_JARS = new String[]{"deploy.jar", "javaws.jar", "plugin.jar", "plugin-legacy.jar"};
        MEMSIZES = new long[]{0x10000000L, 0xC000000L, 0x8000000L, 0x4000000L, 0x3000000L, 0x2000000L};
    }

    static class ArgumentSet {
        private final LinkedHashSet<String> dashXOptions = new LinkedHashSet();
        private final LinkedHashSet<Property> systemProperties = new LinkedHashSet();
        private final LinkedHashSet<String> otherArguments = new LinkedHashSet();
        public static final int NUM_ARGUMENT_LISTS = 3;

        ArgumentSet() {
        }

        public void clear() {
            this.dashXOptions.clear();
            this.systemProperties.clear();
            this.otherArguments.clear();
        }

        private String[] systemProperties2StringArray() {
            String[] stringArray = new String[this.systemProperties.size()];
            int n = 0;
            Iterator iterator = this.systemProperties.iterator();
            while (iterator.hasNext()) {
                stringArray[n++] = ((Property)iterator.next()).toString();
            }
            return stringArray;
        }

        public void copyToStringArrays(String[][] stringArray, int n) {
            stringArray[n + 0] = this.dashXOptions.toArray(new String[0]);
            stringArray[n + 1] = this.systemProperties2StringArray();
            stringArray[n + 2] = this.otherArguments.toArray(new String[0]);
        }

        public void getFromStringArrays(String[][] stringArray, int n) {
            this.dashXOptions.addAll(Arrays.asList(stringArray[n + 0]));
            for (String string : stringArray[n + 1]) {
                this.systemProperties.add(new Property(string));
            }
            this.otherArguments.addAll(Arrays.asList(stringArray[n + 2]));
        }

        public void addAll(ArgumentSet argumentSet) {
            this.dashXOptions.addAll(argumentSet.dashXOptions);
            this.systemProperties.addAll(argumentSet.systemProperties);
            this.otherArguments.addAll(argumentSet.otherArguments);
        }

        public void addAll(ArgumentSet argumentSet, JVMParameterConverter jVMParameterConverter) {
            String string;
            for (Object e : argumentSet.dashXOptions) {
                string = jVMParameterConverter.convert((String)e);
                if (string == null) continue;
                this.dashXOptions.add(string);
            }
            for (Object e : argumentSet.systemProperties) {
                string = jVMParameterConverter.convert(((Property)e).toString());
                if (string == null) continue;
                this.systemProperties.add(Property.createProperty(string));
            }
            for (Object e : argumentSet.otherArguments) {
                string = jVMParameterConverter.convert((String)e);
                if (string == null) continue;
                this.otherArguments.add(string);
            }
        }

        public void addAll(Properties properties) {
            Enumeration<?> enumeration = properties.propertyNames();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                String string2 = properties.getProperty(string);
                String string3 = (String)knownDefaultValues.get(string);
                if (string3 != null && string3.equals(string2)) continue;
                this.systemProperties.add(new Property(string, string2));
            }
        }

        public void addAll(List<Property> list) {
            for (Property property : list) {
                this.systemProperties.add(property);
            }
        }

        public void addTo(List<String> list, boolean bl) {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (String object : this.otherArguments) {
                if (!bl && !Config.isSecureVmArg(object)) continue;
                arrayList.add(object);
            }
            for (String string : this.dashXOptions) {
                if (!bl && !Config.isSecureVmArg(string)) continue;
                list.add(string);
            }
            for (Property property : this.systemProperties) {
                if (!bl && !property.isSecure()) continue;
                list.add(property.toString());
            }
            list.addAll(arrayList);
        }

        public void addTo(Properties properties) {
            for (Property property : this.systemProperties) {
                property.addTo(properties);
            }
        }

        public boolean addArgument(String string, boolean bl, boolean bl2) {
            if (string.startsWith("-Dsun.plugin2.jvm.args")) {
                throw new IllegalArgumentException("May not specify the sun.plugin2.jvm.args system property");
            }
            if (bl) {
                Property property = Property.createProperty(string);
                if (property != null) {
                    if (knownDefaultValues.containsKey(property.getKey()) && ((String)knownDefaultValues.get(property.getKey())).equals(property.getValue())) {
                        return true;
                    }
                    if (bl2) {
                        if (!Config.isLegalExtendedASCIIProperty(property.getKey(), property.getValue())) {
                            Trace.println("Rejecting property with illegal chars: " + string, TraceLevel.SECURITY);
                            return false;
                        }
                    } else if (!Config.isLegalProperty(property.getKey(), property.getValue())) {
                        Trace.println("Rejecting property with illegal chars: " + string, TraceLevel.SECURITY);
                        return false;
                    }
                    this.systemProperties.add(property);
                    return true;
                }
                if (string.startsWith("-X")) {
                    if (string.startsWith("-Xbootclasspath:") || string.startsWith("-Xbootclasspath/p:")) {
                        return true;
                    }
                    if (!Config.isLegalArgument(string)) {
                        Trace.println("Rejecting argument with illegal chars: " + string, TraceLevel.SECURITY);
                        return false;
                    }
                    this.dashXOptions.add(string);
                    return true;
                }
            }
            if (!Config.isLegalArgument(string)) {
                Trace.println("Rejecting argument with illegal chars: " + string, TraceLevel.SECURITY);
                return false;
            }
            this.otherArguments.add(string);
            return string.startsWith("-");
        }

        public boolean removeArgument(String string) {
            if (string.startsWith("-X")) {
                return this.removeArgumentHelper(this.dashXOptions, string);
            }
            if (string.startsWith("-D")) {
                return this.removeArgumentHelper(this.systemProperties, new Property(string));
            }
            return this.removeArgumentHelper(this.otherArguments, string);
        }

        private boolean removeArgumentHelper(LinkedHashSet<Property> linkedHashSet, Property property) {
            return linkedHashSet.remove(property);
        }

        private boolean removeArgumentHelper(LinkedHashSet<String> linkedHashSet, String string) {
            for (String string2 : linkedHashSet) {
                if (!string2.startsWith(string)) continue;
                linkedHashSet.remove(string2);
                return true;
            }
            return false;
        }

        public boolean isDefault() {
            return this.dashXOptions.isEmpty() && this.systemProperties.isEmpty() && this.otherArguments.isEmpty();
        }

        public boolean isSecure() {
            Iterator iterator = this.dashXOptions.iterator();
            while (iterator.hasNext()) {
                if (Config.isSecureVmArg((String)iterator.next())) continue;
                return false;
            }
            iterator = this.otherArguments.iterator();
            while (iterator.hasNext()) {
                if (Config.isSecureVmArg((String)iterator.next())) continue;
                return false;
            }
            for (Property property : this.systemProperties) {
                if (property.isSecure()) continue;
                return false;
            }
            return true;
        }

        public int size() {
            return this.dashXOptions.size() + this.systemProperties.size() + this.otherArguments.size();
        }

        public String get(int n) {
            if (n < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (n < this.dashXOptions.size()) {
                for (String object : this.dashXOptions) {
                    if (n-- != 0) continue;
                    return object;
                }
            }
            if ((n -= this.dashXOptions.size()) < this.systemProperties.size()) {
                for (Property property : this.systemProperties) {
                    if (n-- != 0) continue;
                    return property.toString();
                }
            }
            if ((n -= this.systemProperties.size()) < this.otherArguments.size()) {
                for (String string : this.otherArguments) {
                    if (n-- != 0) continue;
                    return string;
                }
            }
            throw new IndexOutOfBoundsException();
        }
    }
}

