/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.util;

import com.sun.deploy.config.JREInfo;
import com.sun.deploy.config.JfxRuntime;
import com.sun.deploy.trace.Trace;
import java.io.File;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.Policy;
import java.security.Security;

public class FXLoader {
    private static final String POLICY_URL = "policy.url.";
    private static final String JAVAFX_RUNTIME_PROPERTY = "javafx.runtime.home";

    private static void registerJavaFXPolicy(JfxRuntime jfxRuntime) throws MalformedURLException {
        int n = 1;
        while (Security.getProperty(POLICY_URL + n) != null) {
            ++n;
        }
        File file = jfxRuntime.getHome();
        File file2 = new File(file, "lib/security/javafx.policy");
        if (file2.exists() && file2.canRead()) {
            Security.setProperty(POLICY_URL + n, file2.toURI().toURL().toString());
            System.setProperty(JAVAFX_RUNTIME_PROPERTY, file.toString());
            Policy.getPolicy().refresh();
        }
    }

    private static void addURL(URLClassLoader uRLClassLoader, URL uRL) throws Exception {
        Class<URLClassLoader> clazz = URLClassLoader.class;
        Method method = clazz.getDeclaredMethod("addURL", URL.class);
        method.setAccessible(true);
        method.invoke((Object)uRLClassLoader, uRL);
    }

    private static void loadFX(JfxRuntime jfxRuntime) throws ClassNotFoundException {
        if (null == jfxRuntime) {
            throw new ClassNotFoundException();
        }
        URL uRL = jfxRuntime.getFX2URL();
        if (uRL == null) {
            return;
        }
        URLClassLoader uRLClassLoader = null;
        for (ClassLoader classLoader = Thread.currentThread().getContextClassLoader(); classLoader != null; classLoader = classLoader.getParent()) {
            if (!(classLoader instanceof URLClassLoader)) continue;
            uRLClassLoader = (URLClassLoader)classLoader;
        }
        try {
            FXLoader.addURL(uRLClassLoader, uRL);
        }
        catch (Exception exception) {
            throw new ClassNotFoundException("Failed to add JavaFX Runtime", exception);
        }
        try {
            FXLoader.registerJavaFXPolicy(jfxRuntime);
        }
        catch (Exception exception) {
            Trace.ignored(exception);
            throw new ClassNotFoundException("Failed to register jfx Policy");
        }
    }

    public static void loadFX() throws ClassNotFoundException {
        JfxRuntime jfxRuntime = JREInfo.getHomeJRE().getJfxRuntime();
        FXLoader.loadFX(jfxRuntime);
    }
}

