/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.util;

import com.sun.deploy.config.Config;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.deploy.util.Base64Wrapper;
import com.sun.deploy.util.DeployJavaUtilJarAccess;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StreamTokenizer;
import java.security.AccessController;
import java.security.GeneralSecurityException;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import sun.security.util.BitArray;

public final class BlackList {
    private static BlackList INSTANCE = null;
    private static final String DIGEST_MANIFEST = "-DIGEST-MANIFEST";
    private static final String CACHE_VERSION = "v2";
    private static final int BITLEN = 65536;
    private static final int WORDLEN = 2;
    private static final int NEED_CREATE = 0;
    private static final int NEED_LOAD = 1;
    private static final int IN_MEMORY = 2;
    private static final String[] stateStrings = new String[]{"NEED_CREATE", "NEED_LOAD", "IN_MEMORY"};
    private List<File> rawBlacklistFiles;
    private Cache cachedBlacklistFile;
    private SmartBitArray cache;
    private long lastModified;
    private boolean isEmpty;
    private int state;

    private static BlackList createDefaultInstance() {
        BlackList blackList = null;
        if (Config.getBooleanProperty("deployment.security.blacklist.check")) {
            Trace.msgSecurityPrintln("downloadengine.check.blacklist.enabled");
            blackList = new BlackList(false);
        }
        if (blackList == null) {
            blackList = new BlackList(true);
        }
        return blackList;
    }

    public static synchronized BlackList getInstance() {
        if (INSTANCE == null) {
            INSTANCE = BlackList.createDefaultInstance();
        }
        return INSTANCE;
    }

    static String getCachePath() {
        return BlackList.getInstance().cachedBlacklistFile.file.getPath();
    }

    private BlackList(boolean bl) {
        this.isEmpty = bl;
        if (bl) {
            this.lastModified = 0L;
        } else {
            String string = Config.getDynamicBlacklistFile();
            String string2 = Config.getSystemBlacklistFile();
            String string3 = Config.getUserBlacklistFile();
            this.rawBlacklistFiles = new ArrayList<File>();
            this.rawBlacklistFiles.add(new File(string));
            this.rawBlacklistFiles.add(new File(string2));
            this.rawBlacklistFiles.add(new File(string3));
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(CACHE_VERSION).append('|');
            Iterator<File> iterator = this.rawBlacklistFiles.iterator();
            boolean bl2 = false;
            while (iterator.hasNext()) {
                File file = iterator.next();
                stringBuilder.append(file.getPath()).append('|');
                long l = file.lastModified();
                if (l != 0L) {
                    bl2 = true;
                }
                stringBuilder.append(l).append('|');
            }
            if (!bl2) {
                this.isEmpty = true;
                this.lastModified = 0L;
                Trace.println("blacklist: no raw file", TraceLevel.SECURITY);
                return;
            }
            this.cachedBlacklistFile = new Cache(stringBuilder.toString().hashCode());
            if (this.cachedBlacklistFile.exists()) {
                this.state = 1;
                this.lastModified = this.cachedBlacklistFile.lastModified();
            } else {
                this.state = 0;
                this.lastModified = new Date().getTime();
            }
        }
        Trace.println("blacklist: created: " + stateStrings[this.state] + ", lastModified: " + this.lastModified, TraceLevel.SECURITY);
    }

    public synchronized boolean contains(String string, String string2) {
        if (this.isEmpty) {
            return false;
        }
        Trace.println("blacklist: check contains " + string2 + ", state now " + stateStrings[this.state], TraceLevel.SECURITY);
        if (this.state == 0) {
            return this.checkInRaw(string, string2, true);
        }
        try {
            if (this.state == 1) {
                this.cache = this.cachedBlacklistFile.loadCache();
                this.state = 2;
            }
        }
        catch (IOException iOException) {
            return this.checkInRaw(string, string2, true);
        }
        boolean bl = this.checkInCache(string2);
        Trace.println("blacklist: " + (bl ? "" : "not ") + " found in cache", TraceLevel.SECURITY);
        if (bl) {
            return this.checkInRaw(string, string2, false);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean updateCache() {
        BlackList blackList = BlackList.getInstance();
        if (blackList.state == 0) {
            BlackList blackList2 = blackList;
            synchronized (blackList2) {
                blackList.checkInRaw(null, null, true);
            }
            return true;
        }
        return false;
    }

    private boolean checkInCache(String string) {
        byte[] byArray = BlackList.debase64(string);
        if (byArray.length == 0) {
            return false;
        }
        int n = 0;
        while (n + 2 <= byArray.length) {
            int n2 = 0;
            for (int i = 0; i < 2; ++i) {
                n2 <<= 8;
                n2 |= byArray[n + i] & 0xFF;
            }
            if (!this.cache.get(n2)) {
                return false;
            }
            n += 2;
        }
        return true;
    }

    private boolean checkInRaw(String string, String string2, boolean bl) {
        if (bl) {
            this.cache = new SmartBitArray(65536);
        }
        Iterator<File> iterator = this.rawBlacklistFiles.iterator();
        boolean bl2 = false;
        while (iterator.hasNext()) {
            File file = iterator.next();
            if (bl2) {
                this.checkInOneRaw(file, null, null, true);
                Trace.println("blacklist: read raw " + file, TraceLevel.SECURITY);
            } else {
                bl2 = this.checkInOneRaw(file, string, string2, bl);
                Trace.println("blacklist: check raw " + file + ", " + bl2, TraceLevel.SECURITY);
            }
            if (!bl2 || bl) continue;
            return true;
        }
        if (bl) {
            this.saveCache();
        }
        return bl2;
    }

    private void saveCache() {
        if (this.cache.isEmpty()) {
            this.isEmpty = true;
            Trace.println("blacklist: raw files are all empty", TraceLevel.SECURITY);
            this.cachedBlacklistFile.delete();
        } else {
            this.cachedBlacklistFile.save(this.cache);
        }
        this.state = 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkInOneRaw(final File file, String string, String string2, boolean bl) {
        boolean bl2;
        block27: {
            if (!file.exists()) {
                return false;
            }
            BufferedReader bufferedReader = null;
            bl2 = false;
            try {
                String string3;
                FileInputStream fileInputStream = AccessController.doPrivileged(new PrivilegedExceptionAction<FileInputStream>(){

                    @Override
                    public FileInputStream run() throws Exception {
                        return new FileInputStream(file);
                    }
                });
                bufferedReader = new BufferedReader(new InputStreamReader(fileInputStream));
                StreamTokenizer streamTokenizer = new StreamTokenizer(bufferedReader);
                this.setupTokenizer(streamTokenizer);
                while (true) {
                    int n;
                    if ((n = streamTokenizer.nextToken()) == -1) {
                        break block27;
                    }
                    if (n == 10) continue;
                    if (n != -3) {
                        throw new IOException("Unexpected token: " + streamTokenizer);
                    }
                    string3 = streamTokenizer.sval;
                    if (!string3.toUpperCase(Locale.ENGLISH).endsWith(DIGEST_MANIFEST)) break;
                    String string4 = streamTokenizer.sval;
                    this.parseColon(streamTokenizer);
                    streamTokenizer.wordChars(61, 61);
                    n = streamTokenizer.nextToken();
                    if (n != -3) {
                        throw new IOException("Unexpected value: " + streamTokenizer);
                    }
                    streamTokenizer.ordinaryChar(61);
                    String string5 = streamTokenizer.sval;
                    if (string5 == null) {
                        throw new IOException("hash must be specified");
                    }
                    if (string5.equals(string2) && string4.equalsIgnoreCase(string)) {
                        bl2 = true;
                        if (!bl) {
                            boolean bl3 = bl2;
                            return bl3;
                        }
                    }
                    if (!bl) continue;
                    this.encode(string5);
                }
                throw new IOException("Unknown attribute `" + string3 + "', line " + streamTokenizer.lineno());
            }
            catch (PrivilegedActionException privilegedActionException) {
                Trace.println("blacklist: PrivilegedActionException: " + privilegedActionException, TraceLevel.SECURITY);
            }
            catch (IOException iOException) {
                Trace.println("blacklist: " + iOException, TraceLevel.SECURITY);
            }
            finally {
                if (bufferedReader != null) {
                    try {
                        bufferedReader.close();
                    }
                    catch (IOException iOException) {
                        Trace.println("blacklist: Cannot close reader for " + file, TraceLevel.SECURITY);
                    }
                }
            }
        }
        return bl2;
    }

    private void encode(String string) {
        byte[] byArray = BlackList.debase64(string);
        int n = 0;
        while (n + 2 <= byArray.length) {
            int n2 = 0;
            for (int i = 0; i < 2; ++i) {
                n2 <<= 8;
                n2 |= byArray[n + i] & 0xFF;
            }
            this.cache.set(n2, true);
            n += 2;
        }
    }

    private static byte[] debase64(String string) {
        try {
            return Base64Wrapper.decodeFromString(string);
        }
        catch (IOException iOException) {
            Trace.println("blacklist: Cannot decode " + string, TraceLevel.SECURITY);
            return new byte[0];
        }
    }

    public boolean isEmpty() {
        return this.isEmpty;
    }

    private void setupTokenizer(StreamTokenizer streamTokenizer) {
        streamTokenizer.resetSyntax();
        streamTokenizer.wordChars(97, 122);
        streamTokenizer.wordChars(65, 90);
        streamTokenizer.wordChars(48, 57);
        streamTokenizer.wordChars(46, 46);
        streamTokenizer.wordChars(45, 45);
        streamTokenizer.wordChars(95, 95);
        streamTokenizer.wordChars(43, 43);
        streamTokenizer.wordChars(47, 47);
        streamTokenizer.whitespaceChars(0, 32);
        streamTokenizer.commentChar(35);
        streamTokenizer.eolIsSignificant(true);
    }

    private void parseColon(StreamTokenizer streamTokenizer) throws IOException {
        int n = streamTokenizer.nextToken();
        if (n != 58) {
            throw new IOException("Expected ':', read " + streamTokenizer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Attributes readAttributes(JarFile jarFile, JarEntry jarEntry) throws IOException {
        if (jarFile.getJarEntry(jarEntry.getName()) == null) {
            return null;
        }
        final InputStream inputStream = jarFile.getInputStream(jarEntry);
        if (inputStream == null) {
            return null;
        }
        try {
            Attributes attributes = AccessController.doPrivileged(new PrivilegedExceptionAction<Attributes>(){

                @Override
                public Attributes run() throws Exception {
                    Manifest manifest = new Manifest(inputStream);
                    return manifest.getMainAttributes();
                }
            });
            return attributes;
        }
        catch (PrivilegedActionException privilegedActionException) {
        }
        finally {
            inputStream.close();
        }
        return null;
    }

    public boolean checkJarEntry(JarFile jarFile, JarEntry jarEntry) throws IOException, GeneralSecurityException {
        if (this.isEmpty() || jarEntry == null) {
            return true;
        }
        if (!jarEntry.getName().toUpperCase(Locale.ENGLISH).endsWith(".SF")) {
            return false;
        }
        Attributes attributes = BlackList.readAttributes(jarFile, jarEntry);
        if (attributes == null) {
            return false;
        }
        Iterator<Object> iterator = attributes.keySet().iterator();
        while (iterator.hasNext()) {
            Attributes.Name name;
            String string;
            String string2 = iterator.next().toString();
            if (!string2.toUpperCase(Locale.ENGLISH).endsWith(DIGEST_MANIFEST) || !INSTANCE.contains(string2, string = attributes.getValue(name = new Attributes.Name(string2)))) continue;
            Trace.msgSecurityPrintln("downloadengine.check.blacklist.found", new Object[]{jarFile.getName()});
            throw new GeneralSecurityException("blacklisted entry!");
        }
        Trace.msgSecurityPrintln("downloadengine.check.blacklist.notfound");
        return false;
    }

    public boolean checkJarFile(JarFile jarFile) throws IOException {
        if (this.isEmpty()) {
            Trace.msgSecurityPrintln("downloadengine.check.blacklist.notexist");
            return false;
        }
        List<Object> list = BlackList.getManifestDigests(jarFile);
        if (list != null && list.size() > 0) {
            try {
                Iterator<Object> iterator = list.iterator();
                while (iterator.hasNext()) {
                    String string;
                    String string2 = (String)iterator.next();
                    if (!INSTANCE.contains(string2, string = (String)iterator.next())) continue;
                    Trace.msgSecurityPrintln("downloadengine.check.blacklist.found", new Object[]{jarFile.getName()});
                    return true;
                }
                return false;
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
        }
        Enumeration<JarEntry> enumeration = jarFile.entries();
        while (enumeration.hasMoreElements()) {
            JarEntry jarEntry = enumeration.nextElement();
            String string = jarEntry.getName().toUpperCase(Locale.ENGLISH);
            if (!string.startsWith("META-INF/") && !string.startsWith("/META-INF/")) continue;
            try {
                if (!this.checkJarEntry(jarFile, jarEntry)) continue;
                return false;
            }
            catch (GeneralSecurityException generalSecurityException) {
                return true;
            }
        }
        Trace.msgSecurityPrintln("downloadengine.check.blacklist.notsigned");
        return false;
    }

    public boolean hasBeenModifiedSince(long l) {
        Trace.println("blacklist: hasBeenModifiedSince " + l + " (we have " + this.lastModified + ")", TraceLevel.SECURITY);
        return this.lastModified >= l;
    }

    private static List<Object> getManifestDigests(JarFile jarFile) {
        try {
            DeployJavaUtilJarAccess deployJavaUtilJarAccess = DeployJavaUtilJarAccess.instance();
            return deployJavaUtilJarAccess.getManifestDigests(jarFile);
        }
        catch (NoSuchMethodError noSuchMethodError) {
            return null;
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            return null;
        }
    }

    private static class Cache {
        File file = new File(Config.getSecurityCacheDir(), "blacklist.cache");
        int signature;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Cache(int n) {
            this.signature = n;
            FileInputStream fileInputStream = null;
            boolean bl = false;
            try {
                fileInputStream = new FileInputStream(this.file);
                if (new DataInputStream(fileInputStream).readInt() != n) {
                    bl = true;
                }
            }
            catch (IOException iOException) {
                bl = true;
            }
            finally {
                try {
                    if (fileInputStream != null) {
                        fileInputStream.close();
                    }
                }
                catch (IOException iOException) {
                    Trace.println("blacklist: Cannot close " + this.file, TraceLevel.SECURITY);
                }
            }
            if (bl) {
                Trace.println("blacklist: Reconstruct cache", TraceLevel.SECURITY);
                this.file.delete();
            }
        }

        long lastModified() {
            return this.file.lastModified();
        }

        boolean exists() {
            return this.file.exists();
        }

        void delete() {
            this.file.delete();
        }

        SmartBitArray loadCache() throws IOException {
            Trace.println("blacklist: loadCache", TraceLevel.SECURITY);
            byte[] byArray = new byte[8192];
            FileInputStream fileInputStream = null;
            try {
                fileInputStream = new FileInputStream(this.file);
                fileInputStream.read(byArray, 0, 4);
                fileInputStream.read(byArray);
            }
            finally {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
            return new SmartBitArray(65536, byArray);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void save(SmartBitArray smartBitArray) {
            Trace.println("blacklist: save cache to " + this.file, TraceLevel.SECURITY);
            FileOutputStream fileOutputStream = null;
            try {
                new File(Config.getSecurityCacheDir()).mkdir();
                fileOutputStream = new FileOutputStream(this.file);
                new DataOutputStream(fileOutputStream).writeInt(this.signature);
                fileOutputStream.write(smartBitArray.toByteArray());
            }
            catch (IOException iOException) {
                if (fileOutputStream != null) {
                    try {
                        fileOutputStream.close();
                    }
                    catch (IOException iOException2) {
                        Trace.println("blacklist: Cannot close " + this.file, TraceLevel.SECURITY);
                    }
                    fileOutputStream = null;
                }
                this.file.delete();
                Trace.println("blacklist: Cannot save cache", TraceLevel.SECURITY);
            }
            finally {
                if (fileOutputStream != null) {
                    try {
                        fileOutputStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    private static class SmartBitArray
    extends BitArray {
        private boolean isEmpty = true;

        SmartBitArray(int n) {
            super(n);
        }

        SmartBitArray(int n, byte[] byArray) {
            super(n, byArray);
            this.isEmpty = false;
        }

        @Override
        public void set(int n, boolean bl) throws ArrayIndexOutOfBoundsException {
            super.set(n, bl);
            this.isEmpty = false;
        }

        boolean isEmpty() {
            return this.isEmpty;
        }
    }
}

