/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.security;

import com.sun.deploy.security.MSCryptoDSASignature;
import com.sun.deploy.security.WIExplorerMyKeyStore;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.InvalidParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.security.Provider;
import java.security.ProviderException;
import java.security.SecurityPermission;

public final class MSCryptoProvider
extends Provider {
    private static final long serialVersionUID = 2851292589714761768L;
    private static final String info = "SunDeploy-MSCrypto Provider (implements DSA)";
    private static final AccessControlContext ACC_INSTANCE;

    public MSCryptoProvider() {
        super("SunDeploy-MSCrypto", 1.5, info);
        final MSCryptoProvider mSCryptoProvider = this;
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                MSCryptoProvider.this.putService(new ProviderService(mSCryptoProvider, "Signature", "DSA", "com.sun.deploy.security.MSCryptoDSASignature$SHA1withDSA"));
                MSCryptoProvider.this.putService(new ProviderService(mSCryptoProvider, "Signature", "RawDSA", "com.sun.deploy.security.MSCryptoDSASignature$NONEwithDSA"));
                MSCryptoProvider.this.putService(new ProviderService(mSCryptoProvider, "KeyStore", "WIExplorerMy", "com.sun.deploy.security.WIExplorerMyKeyStore"));
                return null;
            }
        }, ACC_INSTANCE);
    }

    static {
        Permissions permissions = new Permissions();
        SecurityPermission securityPermission = new SecurityPermission("putProviderProperty.SunDeploy-MSCrypto");
        ((PermissionCollection)permissions).add(securityPermission);
        ACC_INSTANCE = new AccessControlContext(new ProtectionDomain[]{new ProtectionDomain(null, permissions)});
    }

    private static final class ProviderService
    extends Provider.Service {
        ProviderService(Provider provider, String string, String string2, String string3) {
            super(provider, string, string2, string3, null, null);
        }

        @Override
        public Object newInstance(Object object) throws NoSuchAlgorithmException {
            String string = this.getType();
            if (object != null) {
                throw new InvalidParameterException("constructorParameter not used with " + string + " engines");
            }
            String string2 = this.getAlgorithm();
            try {
                if (string2.equals("DSA")) {
                    return new MSCryptoDSASignature.SHA1withDSA();
                }
                if (string2.equals("RawDSA")) {
                    return new MSCryptoDSASignature.NONEwithDSA();
                }
                if (string2.equals("WIExplorerMy")) {
                    return new WIExplorerMyKeyStore();
                }
            }
            catch (Exception exception) {
                throw new NoSuchAlgorithmException("Error constructing " + string + " for " + string2 + " using SunDeploy-MSCrypto", exception);
            }
            throw new ProviderException("No impl for " + string2 + " " + string);
        }
    }
}

