/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.security;

import com.sun.deploy.security.CertStore;
import com.sun.deploy.security.CertUtils;
import com.sun.deploy.trace.Trace;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;

final class DeniedCertStore
implements CertStore {
    private KeyStore deniedKS = null;

    DeniedCertStore() {
    }

    @Override
    public void load() throws IOException, CertificateException, KeyStoreException, NoSuchAlgorithmException {
        this.load(false);
    }

    @Override
    public void load(boolean bl) throws IOException, CertificateException, KeyStoreException, NoSuchAlgorithmException {
        if (this.deniedKS == null) {
            try {
                this.deniedKS = KeyStore.getInstance("JKS");
                this.deniedKS.load(null, new char[0]);
            }
            catch (IOException iOException) {
                Trace.msgSecurityPrintln(iOException.getMessage());
            }
            catch (KeyStoreException keyStoreException) {
                Trace.msgSecurityPrintln(keyStoreException.getMessage());
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                Trace.msgSecurityPrintln(noSuchAlgorithmException.getMessage());
            }
            catch (CertificateException certificateException) {
                Trace.msgSecurityPrintln(certificateException.getMessage());
            }
        }
    }

    @Override
    public void save() throws IOException, CertificateException, KeyStoreException, NoSuchAlgorithmException {
    }

    @Override
    public boolean add(Certificate certificate) throws KeyStoreException {
        return this.add(certificate, null, false);
    }

    @Override
    public boolean add(Certificate certificate, String string, boolean bl) throws KeyStoreException {
        return CertUtils.add(this.deniedKS, "deniedcertstore", certificate, string, bl);
    }

    @Override
    public boolean remove(Certificate certificate) throws IOException, KeyStoreException {
        Trace.msgSecurityPrintln("deniedcertstore.cert.removing");
        String string = this.deniedKS.getCertificateAlias(certificate);
        if (string != null) {
            this.deniedKS.deleteEntry(string);
        }
        Trace.msgSecurityPrintln("deniedcertstore.cert.removed");
        return true;
    }

    @Override
    public boolean contains(Certificate certificate) throws KeyStoreException {
        return this.contains(certificate, null, false);
    }

    @Override
    public boolean contains(Certificate certificate, String string, boolean bl) throws KeyStoreException {
        return CertUtils.contains(this.deniedKS, certificate, string, bl);
    }

    @Override
    public boolean verify(Certificate certificate) throws KeyStoreException {
        return false;
    }

    @Override
    public Collection<X509Certificate> getCertificates() throws KeyStoreException {
        Trace.msgSecurityPrintln("deniedcertstore.cert.getcertificates");
        ArrayList<X509Certificate> arrayList = new ArrayList<X509Certificate>();
        Enumeration<String> enumeration = this.deniedKS.aliases();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement();
            X509Certificate x509Certificate = (X509Certificate)this.deniedKS.getCertificate(string);
            arrayList.add(x509Certificate);
        }
        return arrayList;
    }
}

