/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.util;

import com.sun.deploy.Environment;
import com.sun.deploy.config.Config;
import com.sun.deploy.config.JREInfo;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.deploy.util.ArgumentParsingUtil;
import com.sun.deploy.util.JVMParameterConverter;
import com.sun.deploy.util.Property;
import com.sun.deploy.util.StringUtils;
import com.sun.deploy.util.SystemUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public final class JVMParameters {
    private static final boolean DEBUG = false;
    private static final Map<String, String> knownDefaultValues = new HashMap<String, String>();
    private final List<String> internalArguments = new ArrayList<String>();
    private final ArgumentSet trustedArguments = new ArgumentSet();
    private final ArgumentSet arguments = new ArgumentSet();
    private long maxHeap = 0L;
    private boolean isDefault;
    private boolean isHtmlJavaArguments;
    private boolean includeExtendedASCIIValues;
    private static final long DEFAULT_HEAP = 0x4000000L;
    private static final String INTERNAL_SEPARATOR_ARG = "---";
    private static final String TRUSTED_SEPARATOR_ARG = "--";
    private static JVMParameters runningJVMParameters;
    private static final String[] PLUGIN_DEPENDENT_JARS;
    private static final long[] MEMSIZES;

    public JVMParameters() {
        this.clear();
    }

    public boolean isEmpty() {
        return this.internalArguments.isEmpty() && this.trustedArguments.size() == 0 && this.arguments.size() == 0;
    }

    public void clear() {
        this.internalArguments.clear();
        this.clearUserArguments();
    }

    public void clearUserArguments() {
        this.trustedArguments.clear();
        this.arguments.clear();
        this.maxHeap = 0L;
        this.isDefault = true;
    }

    public JVMParameters copy() {
        JVMParameters params = new JVMParameters();
        params.addArguments(this);
        return params;
    }

    public JVMParameters copy(JVMParameterConverter converter) {
        JVMParameters params = new JVMParameters();
        params.addArguments(this, converter);
        return params;
    }

    public String[][] copyToStringArrays() {
        String[][] argArrays = new String[8][];
        argArrays[0] = this.internalArguments.toArray(new String[0]);
        this.trustedArguments.copyToStringArrays(argArrays, 1);
        String[] xmxArray = new String[]{this.getXmx()};
        argArrays[4] = xmxArray;
        this.arguments.copyToStringArrays(argArrays, 5);
        return argArrays;
    }

    public void getFromStringArrays(String[][] argArrays) {
        this.internalArguments.addAll(Arrays.asList(argArrays[0]));
        this.trustedArguments.getFromStringArrays(argArrays, 1);
        String xmx = argArrays[4][0];
        if (xmx != null) {
            this.addArgument(xmx);
        }
        this.arguments.getFromStringArrays(argArrays, 5);
        this.recomputeIsDefault();
    }

    public void parse(String commandLine) {
        this.parseImpl(commandLine, false, false);
    }

    public void parse(String commandLine, boolean secureArgsOnly) {
        this.parseImpl(commandLine, false, secureArgsOnly);
    }

    public void parseTrustedOptions(String commandLine) {
        this.parseImpl(commandLine, true, false);
    }

    private void parseImpl(String commandLine, boolean trusted, boolean secureArgsOnly) {
        List<String> cmdlnArgs;
        if (commandLine == null) {
            return;
        }
        try {
            cmdlnArgs = ArgumentParsingUtil.parseCommandLine(commandLine);
        }
        catch (IllegalArgumentException iae) {
            System.out.println(iae.getMessage());
            return;
        }
        boolean checkForJVMArg = true;
        Iterator<String> iterator = cmdlnArgs.iterator();
        while (iterator.hasNext()) {
            String cmdlnArg;
            String tmp = cmdlnArg = iterator.next();
            checkForJVMArg = this.addArgumentImpl(tmp, checkForJVMArg, trusted, secureArgsOnly);
        }
    }

    public void addProperties(Properties props) {
        this.arguments.addAll(props);
        this.recomputeIsDefault();
    }

    public void addProperties(List<Property> propList) {
        this.arguments.addAll(propList);
        this.recomputeIsDefault();
    }

    public void addEncodedArguments(String encArgs, boolean trusted, boolean unquote, boolean secureArgsOnly) {
        List<String> args = ArgumentParsingUtil.decodeArgumentList(encArgs);
        if (args != null && !args.isEmpty()) {
            Iterator<String> iterator = args.iterator();
            while (iterator.hasNext()) {
                String arg1;
                String arg = arg1 = iterator.next();
                if (unquote) {
                    arg = ArgumentParsingUtil.unquoteIfNeeded(arg);
                }
                this.addArgumentImpl(arg, true, trusted, secureArgsOnly);
            }
        }
    }

    public void addArgument(String arg) {
        this.addArgument(arg, true);
    }

    public void addArgument(String arg, boolean checkForJVMArg) {
        this.addArgumentImpl(arg, checkForJVMArg, false, false);
    }

    public void addInternalArgument(String arg) {
        this.internalArguments.add(arg);
    }

    public void addArguments(JVMParameters other) {
        if (other == null) {
            return;
        }
        this.internalArguments.addAll(other.internalArguments);
        this.trustedArguments.addAll(other.trustedArguments);
        this.arguments.addAll(other.arguments);
        if (!other.isDefault && other.maxHeap > 0L) {
            this.maxHeap = other.maxHeap;
        } else if (this.isDefault && other.isDefault) {
            this.maxHeap = this.maxHeap != 0L || other.maxHeap != 0L ? Math.max(this.getMaxHeapSize(), other.getMaxHeapSize()) : 0L;
        } else if (0L == this.maxHeap) {
            this.maxHeap = other.maxHeap;
        }
        this.isDefault = this.isDefault && other.isDefault;
    }

    public void addArguments(JVMParameters other, JVMParameterConverter converter) {
        if (other == null) {
            return;
        }
        for (String arg : this.internalArguments) {
            String val = converter.convert(arg);
            if (val == null) continue;
            this.internalArguments.add(val);
        }
        this.trustedArguments.addAll(other.trustedArguments, converter);
        this.arguments.addAll(other.arguments, converter);
    }

    public void removeArgument(String argument) {
        if (argument.startsWith("-Xmx")) {
            this.maxHeap = 0L;
        } else if (!this.trustedArguments.removeArgument(argument)) {
            this.arguments.removeArgument(argument);
        }
        this.recomputeIsDefault();
    }

    public void parseBootClassPath(String[] targetJarNames) {
        String bootClassPath = SystemUtils.priviledgedGetSystemProperty("sun.boot.class.path");
        String jreHome = System.getProperty("java.home");
        this.parseBootClassPath(bootClassPath, jreHome, targetJarNames);
    }

    private void parseBootClassPath(String bootClassPath, String jreHome, String[] targetJarNames) {
        if (targetJarNames != null && targetJarNames.length > 0) {
            Object appendList = null;
            String forcedDeployRoot = Environment.getForcedDeployRoot();
            String forcedBootClassPath = Environment.getForcedBootClassPath();
            if (forcedDeployRoot != null) {
                for (String targetJarName : targetJarNames) {
                    String jarPath = forcedDeployRoot + File.separator + "lib" + File.separator + targetJarName;
                    appendList = appendList == null ? jarPath : (String)appendList + File.pathSeparator + jarPath;
                }
                if (appendList != null) {
                    this.addInternalArgument("-Xbootclasspath/a:" + appendList);
                }
            } else if (forcedBootClassPath != null) {
                this.addInternalArgument("-Xbootclasspath/p:" + forcedBootClassPath);
            } else if (bootClassPath != null) {
                String[] entries;
                try {
                    entries = bootClassPath.split(File.pathSeparator);
                }
                catch (NoSuchMethodError nsme) {
                    entries = StringUtils.splitString(bootClassPath, File.pathSeparator);
                }
                block3: for (String curEntry : entries) {
                    for (String targetJarName : targetJarNames) {
                        if (!curEntry.endsWith(targetJarName)) continue;
                        if (appendList == null) {
                            appendList = curEntry;
                            continue block3;
                        }
                        appendList = (String)appendList + File.pathSeparator + curEntry;
                        continue block3;
                    }
                }
                if (appendList != null) {
                    this.addInternalArgument("-Xbootclasspath/a:" + (String)appendList);
                }
            } else if (jreHome != null) {
                for (String targetJarName : targetJarNames) {
                    String jarPath = jreHome + File.separator + "lib" + File.separator + targetJarName;
                    appendList = appendList == null ? jarPath : (String)appendList + File.pathSeparator + jarPath;
                }
                if (appendList != null) {
                    this.addInternalArgument("-Xbootclasspath/a:" + appendList);
                }
            }
        }
    }

    public static String[] getPlugInDependentJars() {
        return (String[])PLUGIN_DEPENDENT_JARS.clone();
    }

    public List<String> getCommandLineArguments(JREInfo jreInfo, boolean includeSeparatorArgument) {
        return this.getCommandLineArguments(jreInfo, includeSeparatorArgument, true, true, true, false);
    }

    public List<String> getCommandLineArguments(JREInfo jreInfo, boolean includeSeparatorArgument, boolean includeInternalArguments, boolean includeTrustedArguments, boolean includeInsecureArgs, boolean jweblauncherArgs) {
        String xmx;
        ArrayList<String> args = new ArrayList<String>();
        if (includeInternalArguments) {
            boolean isModular = jreInfo != null ? jreInfo.isModularJRE() : false;
            for (String stmp : this.internalArguments) {
                if (isModular) {
                    if (jweblauncherArgs) {
                        if (stmp.startsWith("-Xbootclasspath/a") || stmp.startsWith("-Djava.class.path")) continue;
                        args.add(stmp);
                        continue;
                    }
                    if (stmp.startsWith("-Xbootclasspath/a")) continue;
                    args.add(stmp);
                    continue;
                }
                if (jweblauncherArgs) {
                    if (stmp.startsWith("-Xbootclasspath/a") || stmp.startsWith("-Djava.class.path")) continue;
                    args.add(stmp);
                    continue;
                }
                args.add(stmp);
            }
        }
        if (includeSeparatorArgument) {
            args.add(INTERNAL_SEPARATOR_ARG);
        }
        if (includeTrustedArguments) {
            this.trustedArguments.addTo(args, includeInsecureArgs);
        }
        if (includeSeparatorArgument) {
            args.add(TRUSTED_SEPARATOR_ARG);
        }
        if ((xmx = this.getXmx()) != null) {
            args.add(xmx);
        }
        this.arguments.addTo(args, includeInsecureArgs);
        this.ensureNoDuplicates(args);
        return args;
    }

    private void ensureNoDuplicates(List<String> args) {
        HashSet<String> processed = new HashSet<String>();
        Iterator<String> it = args.iterator();
        while (it.hasNext()) {
            String arg = it.next();
            if (processed.contains(arg)) {
                it.remove();
                continue;
            }
            processed.add(arg);
        }
    }

    public String getEncodedArguments(boolean trusted) {
        List<String> args = this.getCommandLineArguments(null, false, false, trusted, !trusted, false);
        return ArgumentParsingUtil.encodeArgumentList(args);
    }

    public void addTo(Properties props) {
        this.trustedArguments.addTo(props);
        this.arguments.addTo(props);
    }

    public Properties getProperties() {
        Properties props = new Properties();
        this.addTo(props);
        return props;
    }

    public void setDefault(boolean isDefault) {
        this.isDefault = isDefault;
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    public void setHtmlJavaArgs(boolean isHtmlJavaArgs) {
        this.isHtmlJavaArguments = isHtmlJavaArgs;
    }

    public boolean isHtmlJavaArgs() {
        return this.isHtmlJavaArguments;
    }

    public void setIncludeExtendedASCIIValues(boolean includeExtendedASCIIValues) {
        this.includeExtendedASCIIValues = includeExtendedASCIIValues;
    }

    public boolean satisfies(JVMParameters other) {
        if (other == null) {
            return false;
        }
        if (this.getMaxHeapSize() < other.getMaxHeapSize()) {
            return false;
        }
        if (this.isDefault && other.isDefault) {
            return true;
        }
        if (this.isSecure() != other.isSecure()) {
            return false;
        }
        if (!this.isDefault && other.isDefault) {
            return false;
        }
        int otherSz = other.size();
        for (int i = 0; i < otherSz; ++i) {
            String arg = other.get(i);
            if (this.isExcluded(arg) || this.contains(arg)) continue;
            return false;
        }
        return !this.isHtmlJavaArgs() || this.size() == otherSz;
    }

    public boolean satisfiesSecure(JVMParameters other) {
        if (other == null) {
            return false;
        }
        if (this.getMaxHeapSize() < other.getMaxHeapSize()) {
            return false;
        }
        if (this.isDefault && other.isDefault) {
            return true;
        }
        if (!this.isDefault && other.isDefault) {
            return false;
        }
        int otherSz = other.size();
        for (int i = 0; i < otherSz; ++i) {
            String arg = other.get(i);
            if (!JVMParameters.isSecureArgument(arg) || this.isExcluded(arg) || this.contains(arg)) continue;
            return false;
        }
        return true;
    }

    private static boolean isSecureArgument(String arg) {
        Property prop = Property.createProperty(arg);
        if (prop != null) {
            return prop.isSecure();
        }
        return Config.isSecureVmArg(arg);
    }

    public static boolean isJVMCommandLineArgument(String arg) {
        if (arg == null) {
            return false;
        }
        return arg.charAt(0) == '-';
    }

    public long getMaxHeapSize() {
        return this.maxHeap > 0L ? this.maxHeap : JVMParameters.getDefaultHeapSize();
    }

    public void setMaxHeapSize(long v) {
        if (v > 0L) {
            this.maxHeap = v;
        }
        if (this.maxHeap > 0L && this.maxHeap != JVMParameters.getDefaultHeapSize()) {
            this.isDefault = false;
        }
    }

    public static final long getDefaultHeapSize() {
        if (runningJVMParameters == null || !runningJVMParameters.isDefault()) {
            return 0x4000000L;
        }
        try {
            long maxMemory = Runtime.getRuntime().maxMemory();
            long guess = JVMParameters.snapToKnownMemorySize(maxMemory);
            if (guess > 0L) {
                return guess;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return 0x4000000L;
    }

    static long snapToKnownMemorySize(long maxMemory) {
        if (maxMemory < 0L) {
            return 0L;
        }
        long vicinityRange = Math.max(maxMemory / 10L, 0x1000000L);
        for (int i = 0; i < MEMSIZES.length; ++i) {
            if (Math.abs(maxMemory - MEMSIZES[i]) >= vicinityRange) continue;
            return MEMSIZES[i];
        }
        return 0L;
    }

    public static JVMParameters getRunningJVMParameters() {
        return runningJVMParameters;
    }

    public static void setRunningJVMParameters(JVMParameters p) {
        runningJVMParameters = new JVMParameters();
        Properties sysProps = new Properties();
        Config.addSecureSystemPropertiesTo(sysProps);
        runningJVMParameters.addProperties(sysProps);
        runningJVMParameters.addArguments(p);
        if (p != null) {
            runningJVMParameters.setHtmlJavaArgs(p.isHtmlJavaArgs());
        }
    }

    public String toString() {
        StringBuilder buf = new StringBuilder("[JVMParameters: isSecure: " + this.isSecure() + ", args:");
        List<String> args = this.getCommandLineArguments(null, false);
        buf.append(ArgumentParsingUtil.serializeArgumentListForDebugging(args));
        buf.append("]");
        return buf.toString();
    }

    public boolean contains(String argument) {
        int sz = this.size();
        for (int i = 0; i < sz; ++i) {
            if (!argument.equals(this.get(i))) continue;
            return true;
        }
        return false;
    }

    public boolean isExcluded(String argument) {
        return Property.isJnlpProperty(argument);
    }

    public boolean containsPrefix(String argument) {
        int sz = this.size();
        for (int i = 0; i < sz; ++i) {
            if (!this.get(i).startsWith(argument)) continue;
            return true;
        }
        return false;
    }

    public boolean isSecure() {
        return this.arguments.isSecure();
    }

    public static long parseMemorySpec(String spec) throws IllegalArgumentException {
        long modifier = 1L;
        String origSpec = spec;
        for (int i = 0; i < spec.length(); ++i) {
            if (Character.isDigit(spec.charAt(i))) continue;
            if (i != spec.length() - 1) {
                throw new IllegalArgumentException("Too many characters after heap size specifier: " + spec);
            }
            switch (spec.charAt(i)) {
                case 'T': 
                case 't': {
                    modifier = 0x10000000000L;
                    break;
                }
                case 'G': 
                case 'g': {
                    modifier = 0x40000000L;
                    break;
                }
                case 'M': 
                case 'm': {
                    modifier = 0x100000L;
                    break;
                }
                case 'K': 
                case 'k': {
                    modifier = 1024L;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Illegal heap size specifier " + spec.charAt(i) + " in " + origSpec);
                }
            }
            spec = spec.substring(0, spec.length() - 1);
            break;
        }
        try {
            return Long.parseLong(spec) * modifier;
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static String unparseMemorySpec(long val) {
        if (val % 0x10000000000L == 0L) {
            return Long.toString(val / 0x10000000000L) + "t";
        }
        if (val % 0x40000000L == 0L) {
            return Long.toString(val / 0x40000000L) + "g";
        }
        if (val % 0x100000L == 0L) {
            return Long.toString(val / 0x100000L) + "m";
        }
        if (val % 1024L == 0L) {
            return Long.toString(val / 1024L) + "k";
        }
        return Long.toString(val);
    }

    private boolean addArgumentImpl(String arg, boolean checkForJVMArg, boolean trusted, boolean secureArgsOnly) {
        boolean res;
        if (checkForJVMArg && arg.startsWith("-Xmx")) {
            try {
                this.maxHeap = JVMParameters.parseMemorySpec(arg.substring("-Xmx".length()));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            res = true;
        } else {
            res = trusted ? this.trustedArguments.addArgument(arg, checkForJVMArg, this.includeExtendedASCIIValues) : (secureArgsOnly ? (Config.isSecureVmArg(arg) || Config.isSecureSystemProperty(arg) ? this.arguments.addArgument(arg, checkForJVMArg, this.includeExtendedASCIIValues) : true) : this.arguments.addArgument(arg, checkForJVMArg, this.includeExtendedASCIIValues));
        }
        this.recomputeIsDefault();
        return res;
    }

    private String getXmx() {
        if (this.getMaxHeapSize() != JVMParameters.getDefaultHeapSize()) {
            return "-Xmx" + JVMParameters.unparseMemorySpec(this.maxHeap);
        }
        return null;
    }

    private void recomputeIsDefault() {
        this.isDefault = this.getMaxHeapSize() == JVMParameters.getDefaultHeapSize() && this.arguments.isDefault();
    }

    private int size() {
        return this.trustedArguments.size() + this.arguments.size();
    }

    private String get(int index) {
        if (index < this.trustedArguments.size()) {
            return this.trustedArguments.get(index);
        }
        return this.arguments.get(index -= this.trustedArguments.size());
    }

    static {
        knownDefaultValues.put("sun.awt.enableExtraMouseButtons", "true");
        runningJVMParameters = null;
        PLUGIN_DEPENDENT_JARS = new String[]{"deploy.jar", "javaws.jar", "plugin.jar", "plugin-legacy.jar"};
        MEMSIZES = new long[]{0x10000000L, 0xC000000L, 0x8000000L, 0x4000000L, 0x3000000L, 0x2000000L};
    }

    static class ArgumentSet {
        private final LinkedHashSet<String> dashXOptions = new LinkedHashSet();
        private final LinkedHashSet<Property> systemProperties = new LinkedHashSet();
        private final LinkedHashSet<String> otherArguments = new LinkedHashSet();
        public static final int NUM_ARGUMENT_LISTS = 3;

        ArgumentSet() {
        }

        public void clear() {
            this.dashXOptions.clear();
            this.systemProperties.clear();
            this.otherArguments.clear();
        }

        private String[] systemProperties2StringArray() {
            String[] propStrs = new String[this.systemProperties.size()];
            int i = 0;
            Iterator iter = this.systemProperties.iterator();
            while (iter.hasNext()) {
                propStrs[i++] = ((Property)iter.next()).toString();
            }
            return propStrs;
        }

        public void copyToStringArrays(String[][] argArrays, int startIndex) {
            argArrays[startIndex + 0] = this.dashXOptions.toArray(new String[0]);
            argArrays[startIndex + 1] = this.systemProperties2StringArray();
            argArrays[startIndex + 2] = this.otherArguments.toArray(new String[0]);
        }

        public void getFromStringArrays(String[][] argArrays, int startIndex) {
            this.dashXOptions.addAll(Arrays.asList(argArrays[startIndex + 0]));
            for (String argArray : argArrays[startIndex + 1]) {
                this.systemProperties.add(new Property(argArray));
            }
            this.otherArguments.addAll(Arrays.asList(argArrays[startIndex + 2]));
        }

        public void addAll(ArgumentSet other) {
            this.dashXOptions.addAll(other.dashXOptions);
            this.systemProperties.addAll(other.systemProperties);
            this.otherArguments.addAll(other.otherArguments);
        }

        public void addAll(ArgumentSet other, JVMParameterConverter converter) {
            String val;
            for (Object e : other.dashXOptions) {
                val = converter.convert((String)e);
                if (val == null) continue;
                this.dashXOptions.add(val);
            }
            for (Object e : other.systemProperties) {
                val = converter.convert(((Property)e).toString());
                if (val == null) continue;
                this.systemProperties.add(Property.createProperty(val));
            }
            for (Object e : other.otherArguments) {
                val = converter.convert((String)e);
                if (val == null) continue;
                this.otherArguments.add(val);
            }
        }

        public void addAll(Properties props) {
            Enumeration<?> ep = props.propertyNames();
            while (ep.hasMoreElements()) {
                String key = (String)ep.nextElement();
                String val = props.getProperty(key);
                String knownDefaultValue = (String)knownDefaultValues.get(key);
                if (knownDefaultValue != null && knownDefaultValue.equals(val)) continue;
                this.systemProperties.add(new Property(key, val));
            }
        }

        public void addAll(List<Property> propList) {
            for (Property prop : propList) {
                this.systemProperties.add(prop);
            }
        }

        public void addTo(List<String> args, boolean includeInsecureArgs) {
            ArrayList<String> otherArgs = new ArrayList<String>();
            for (String arg : this.otherArguments) {
                if (!includeInsecureArgs && !Config.isSecureVmArg(arg)) continue;
                otherArgs.add(arg);
            }
            for (String arg : this.dashXOptions) {
                if (!includeInsecureArgs && !Config.isSecureVmArg(arg)) continue;
                args.add(arg);
            }
            for (Property prop : this.systemProperties) {
                if (!includeInsecureArgs && !prop.isSecure()) continue;
                args.add(prop.toString());
            }
            args.addAll(otherArgs);
        }

        public void addTo(Properties props) {
            for (Property prop : this.systemProperties) {
                prop.addTo(props);
            }
        }

        public boolean addArgument(String arg, boolean checkForJVMArg, boolean includeExtendedASCIIValues) {
            if (arg.startsWith("-Dsun.plugin2.jvm.args")) {
                throw new IllegalArgumentException("May not specify the sun.plugin2.jvm.args system property");
            }
            if (checkForJVMArg) {
                Property prop = Property.createProperty(arg);
                if (prop != null) {
                    if (knownDefaultValues.containsKey(prop.getKey()) && ((String)knownDefaultValues.get(prop.getKey())).equals(prop.getValue())) {
                        return true;
                    }
                    if (includeExtendedASCIIValues) {
                        if (!Config.isLegalExtendedASCIIProperty(prop.getKey(), prop.getValue())) {
                            Trace.println("Rejecting property with illegal chars: " + arg, TraceLevel.SECURITY);
                            return false;
                        }
                    } else if (!Config.isLegalProperty(prop.getKey(), prop.getValue())) {
                        Trace.println("Rejecting property with illegal chars: " + arg, TraceLevel.SECURITY);
                        return false;
                    }
                    this.systemProperties.add(prop);
                    return true;
                }
                if (arg.startsWith("-X")) {
                    if (arg.startsWith("-Xbootclasspath:") || arg.startsWith("-Xbootclasspath/p:")) {
                        return true;
                    }
                    if (!Config.isLegalArgument(arg)) {
                        Trace.println("Rejecting argument with illegal chars: " + arg, TraceLevel.SECURITY);
                        return false;
                    }
                    this.dashXOptions.add(arg);
                    return true;
                }
            }
            if (!Config.isLegalArgument(arg)) {
                Trace.println("Rejecting argument with illegal chars: " + arg, TraceLevel.SECURITY);
                return false;
            }
            this.otherArguments.add(arg);
            return arg.startsWith("-");
        }

        public boolean removeArgument(String argument) {
            if (argument.startsWith("-X")) {
                return this.removeArgumentHelper(this.dashXOptions, argument);
            }
            if (argument.startsWith("-D")) {
                return this.removeArgumentHelper(this.systemProperties, new Property(argument));
            }
            return this.removeArgumentHelper(this.otherArguments, argument);
        }

        private boolean removeArgumentHelper(LinkedHashSet<Property> props, Property prop) {
            return props.remove(prop);
        }

        private boolean removeArgumentHelper(LinkedHashSet<String> args, String arg) {
            for (String theArg : args) {
                if (!theArg.startsWith(arg)) continue;
                args.remove(theArg);
                return true;
            }
            return false;
        }

        public boolean isDefault() {
            return this.dashXOptions.isEmpty() && this.systemProperties.isEmpty() && this.otherArguments.isEmpty();
        }

        public boolean isSecure() {
            Iterator i = this.dashXOptions.iterator();
            while (i.hasNext()) {
                if (Config.isSecureVmArg((String)i.next())) continue;
                return false;
            }
            i = this.otherArguments.iterator();
            while (i.hasNext()) {
                if (Config.isSecureVmArg((String)i.next())) continue;
                return false;
            }
            for (Property p : this.systemProperties) {
                if (p.isSecure()) continue;
                return false;
            }
            return true;
        }

        public int size() {
            return this.dashXOptions.size() + this.systemProperties.size() + this.otherArguments.size();
        }

        public String get(int index) {
            if (index < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (index < this.dashXOptions.size()) {
                for (String arg : this.dashXOptions) {
                    if (index-- != 0) continue;
                    return arg;
                }
            }
            if ((index -= this.dashXOptions.size()) < this.systemProperties.size()) {
                for (Property prop : this.systemProperties) {
                    if (index-- != 0) continue;
                    return prop.toString();
                }
            }
            if ((index -= this.systemProperties.size()) < this.otherArguments.size()) {
                for (String arg : this.otherArguments) {
                    if (index-- != 0) continue;
                    return arg;
                }
            }
            throw new IndexOutOfBoundsException();
        }
    }
}

