/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.util;

import com.sun.deploy.trace.Trace;
import com.sun.deploy.ui.ImageLoader;
import com.sun.deploy.util.IconEncoder;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferInt;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;

public class IcoEncoder
implements IconEncoder {
    private static final boolean DEBUG = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void convert(File[] images, int[] imagesSizes, int imagesCount, String iconPath) {
        IcoImageEncoder[] imEncoders = new IcoImageEncoder[imagesCount];
        int loadedImagesCount = 0;
        try {
            for (int i = 0; i < imagesCount; ++i) {
                Image awtImage = ImageLoader.getInstance().loadImage(images[i].getPath());
                if (awtImage == null) continue;
                imEncoders[loadedImagesCount] = new IcoImageEncoder(awtImage, imagesSizes[i]);
                imEncoders[loadedImagesCount].createBitmaps();
                ++loadedImagesCount;
            }
        }
        catch (IOException ioe) {
            Trace.ignoredException(ioe);
        }
        imagesCount = loadedImagesCount;
        int[] offset = new int[6];
        offset[0] = 6 + 16 * imagesCount;
        for (int i = 1; i < imagesCount; ++i) {
            offset[i] = offset[i - 1] + 40 + imEncoders[i - 1].getXorData().length + imEncoders[i - 1].getAndData().length;
        }
        FilterOutputStream bos = null;
        try {
            int i;
            bos = new BufferedOutputStream(new FileOutputStream(new File(iconPath)));
            IcoStreamWriter isw = IcoEncoder.getIcoStreamWriter((BufferedOutputStream)bos);
            isw.writeIcoHeader(imagesCount);
            for (i = 0; i < imagesCount; ++i) {
                IcoEncoder.writeIconDirEntry(isw, imEncoders[i].getSize(), offset[i]);
            }
            for (i = 0; i < imagesCount; ++i) {
                IcoEncoder.writeInfoHeader(isw, imEncoders[i].getSize());
                bos.write(imEncoders[i].getXorData());
                bos.write(imEncoders[i].getAndData());
            }
            ((BufferedOutputStream)bos).flush();
        }
        catch (IOException ioe) {
            Trace.ignoredException(ioe);
        }
        finally {
            if (bos != null) {
                try {
                    bos.close();
                }
                catch (Exception e) {
                    Trace.ignoredException(e);
                }
            }
        }
    }

    private static void writeInfoHeader(IcoStreamWriter isw, int size) throws IOException {
        isw.writeDWord(40);
        isw.writeDWord(size);
        isw.writeDWord(2 * size);
        isw.writeWord(1);
        isw.writeWord(24);
        isw.writeDWord(0);
        isw.writeDWord(0);
        isw.writeDWord(0);
        isw.writeDWord(0);
        isw.writeDWord(0);
        isw.writeDWord(0);
    }

    private static void writeIconDirEntry(IcoStreamWriter isw, int size, int dataOffset) throws IOException {
        int andScanSize = IcoEncoder.getAndScanSize(size);
        int scanSize = IcoEncoder.getXorScanSize(size);
        try {
            isw.write(size);
            isw.write(size);
            isw.write(0);
            isw.write(0);
            isw.writeWord(1);
            isw.writeWord(24);
            int length = size * scanSize + size * andScanSize + 40;
            isw.writeDWord(length);
            isw.writeDWord(dataOffset);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    private static int getAndScanSize(int size) {
        int bytes = (size + 7) / 8;
        int dwords = 4 * ((bytes + 3) / 4);
        return dwords;
    }

    private static int getXorScanSize(int size) {
        int bytes = size * 3;
        int dwords = 4 * ((bytes + 3) / 4);
        return dwords;
    }

    private static IcoStreamWriter getIcoStreamWriter(BufferedOutputStream bos) {
        return new IcoStreamWriter(bos);
    }

    public static void printIconFile(File f) {
        Trace.println("Icon: " + f);
        try {
            int len;
            int i;
            FileInputStream fis = new FileInputStream(f);
            byte[] b = new byte[16];
            byte[] h = new byte[6];
            fis.read(h);
            Trace.println("header: " + h[0] + ", " + h[1] + ", " + h[2] + ", " + h[3] + ", " + h[4] + ", " + h[5]);
            int count = h[4];
            for (i = 0; i < count; ++i) {
                fis.read(b);
                Trace.println("Dir entry " + i + ": " + b[0] + ", " + b[1] + ", " + b[2] + ", " + b[3] + ", " + b[4] + ", " + b[5] + ", " + b[6] + ", " + b[7] + ", " + b[8] + ", " + b[9] + ", " + b[10] + ", " + b[11] + ", " + b[12] + ", " + b[13] + ", " + b[14] + ", " + b[15]);
            }
            i = 0;
            Trace.println("InfoHeader: ");
            byte[] ih = new byte[40];
            fis.read(ih);
            for (i = 0; i < 40; ++i) {
                Trace.print(ih[i] + ",");
            }
            Trace.println("\n");
            Trace.println("the rest: ");
            while ((len = fis.read(b)) > 0) {
                Trace.println(" line " + i++ + " : " + b[0] + ", " + b[1] + ", " + b[2] + ", " + b[3] + ", " + b[4] + ", " + b[5] + ", " + b[6] + ", " + b[7] + ", " + b[8] + ", " + b[9] + ", " + b[10] + ", " + b[11] + ", " + b[12] + ", " + b[13] + ", " + b[14] + ", " + b[15]);
            }
        }
        catch (Exception e) {
            Trace.ignoredException(e);
        }
    }

    private static class IcoStreamWriter {
        BufferedOutputStream _bos;

        private IcoStreamWriter(BufferedOutputStream bos) {
            this._bos = bos;
        }

        private void writeIcoHeader(int count) throws IOException {
            try {
                this.writeWord(0);
                this.writeWord(1);
                this.writeWord(count);
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }

        public void write(int b) throws IOException {
            this._bos.write(b);
        }

        public void writeWord(int word) throws IOException {
            this._bos.write(word & 0xFF);
            this._bos.write((word & 0xFF00) >> 8);
        }

        public void writeDWord(int dword) throws IOException {
            this._bos.write(dword & 0xFF);
            this._bos.write((dword & 0xFF00) >> 8);
            this._bos.write((dword & 0xFF0000) >> 16);
            this._bos.write((dword & 0xFF000000) >> 24);
        }
    }

    private static class IcoImageEncoder {
        Image _awtImage;
        int _size;
        byte[] _andData;
        byte[] _xorData;

        public IcoImageEncoder(Image awtImage, int size) {
            this._size = size;
            this._awtImage = awtImage;
            this._andData = new byte[this._size * IcoEncoder.getAndScanSize(this._size)];
            this._xorData = new byte[this._size * IcoEncoder.getXorScanSize(this._size)];
        }

        private int getSize() {
            return this._size;
        }

        private byte[] getXorData() {
            return this._xorData;
        }

        private byte[] getAndData() {
            return this._andData;
        }

        private void createBitmaps() throws IOException {
            int w = this._size;
            int h = this._size;
            int scanSize = IcoEncoder.getXorScanSize(this._size);
            int andScanSize = IcoEncoder.getAndScanSize(this._size);
            byte[] xorPixels = new byte[h * scanSize];
            byte[] andPixels = new byte[h * andScanSize];
            BufferedImage buffImg = new BufferedImage(w, h, 2);
            Graphics2D bg = buffImg.createGraphics();
            bg.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
            bg.drawImage(this._awtImage, 0, 0, w, h, 0, 0, this._awtImage.getWidth(null), this._awtImage.getHeight(null), null);
            bg.dispose();
            DataBuffer imgData = buffImg.getRaster().getDataBuffer();
            int[] pixels = ((DataBufferInt)imgData).getData();
            for (int y = 0; y < h; ++y) {
                int andScan = y * andScanSize;
                int andIndex = 0;
                int xorScan = y * scanSize;
                int xorIndex = 0;
                int maskByte = 0;
                int bitcount = 0;
                for (int x = 0; x < w; ++x) {
                    int j = y * w + x;
                    int alpha = pixels[j] >> 24 & 0xFF;
                    int red = pixels[j] >> 16 & 0xFF;
                    int green = pixels[j] >> 8 & 0xFF;
                    int blue = pixels[j] & 0xFF;
                    if (alpha == 0) {
                        maskByte = (byte)(maskByte | 128 >> bitcount);
                    }
                    if (++bitcount == 8 || x == w - 1) {
                        andPixels[andScan + andIndex++] = maskByte;
                        maskByte = 0;
                        bitcount = 0;
                    }
                    xorPixels[xorScan + xorIndex++] = (byte)blue;
                    xorPixels[xorScan + xorIndex++] = (byte)green;
                    xorPixels[xorScan + xorIndex++] = (byte)red;
                }
                while (andIndex < andScanSize) {
                    andPixels[andScan + andIndex++] = 0;
                }
                while (xorIndex < scanSize) {
                    xorPixels[xorScan + xorIndex++] = 0;
                }
            }
            for (int scan = 0; scan < h; ++scan) {
                int z;
                int dsi = scan * scanSize;
                int ssi = (h - scan - 1) * scanSize;
                for (z = 0; z < scanSize; ++z) {
                    this._xorData[dsi + z] = xorPixels[ssi + z];
                }
                dsi = scan * andScanSize;
                ssi = (h - scan - 1) * andScanSize;
                for (z = 0; z < andScanSize; ++z) {
                    this._andData[dsi + z] = andPixels[ssi + z];
                }
            }
        }
    }
}

