/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.security.ruleset;

import com.sun.deploy.security.CertUtils;
import com.sun.deploy.security.ruleset.DeploymentRuleSet;
import java.security.cert.X509Certificate;

public class RunRule
extends DeploymentRuleSet {
    private String versionString;
    private boolean isForced;
    private String blockedMessage;
    private String location;
    private String customerString;
    private String certAlg;
    private String certHash;

    protected RunRule(String versionString, boolean forced, String blockedMessage, String hash, String alg, String location, String customerString) {
        this.versionString = versionString;
        this.blockedMessage = blockedMessage;
        this.isForced = forced;
        this.certHash = hash;
        this.certAlg = alg;
        this.location = location;
        this.customerString = customerString;
    }

    @Override
    public boolean isCaSignedNever() {
        return false;
    }

    @Override
    public boolean isSelfSignedNever() {
        return false;
    }

    @Override
    public boolean isSSVModeNever() {
        return false;
    }

    @Override
    public boolean isRunLocalAppletsNever() {
        return false;
    }

    @Override
    public boolean isRunUntrustedNever() {
        return false;
    }

    @Override
    public boolean isRunUntrustedMultiClick() {
        return false;
    }

    @Override
    public boolean isSSVModeMultiClick() {
        return false;
    }

    @Override
    public boolean isRevocationCheckBestEffort() {
        return true;
    }

    @Override
    public boolean isExpiredBlocked() {
        return false;
    }

    @Override
    public boolean isPermissionsManifestRequired() {
        return false;
    }

    @Override
    public boolean isAskGrantShowSet() {
        return true;
    }

    @Override
    public boolean isAskGrantSelfSignedSet() {
        return true;
    }

    @Override
    public boolean isLiveConnectAllowedUnchecked() {
        return true;
    }

    @Override
    public boolean isRuleRun() {
        return true;
    }

    @Override
    public boolean isRuleBlock() {
        return false;
    }

    @Override
    public String getMessage() {
        return this.blockedMessage;
    }

    @Override
    public String getCustomerString() {
        return this.customerString;
    }

    @Override
    public String getVersionString() {
        return this.versionString;
    }

    @Override
    public boolean isVersionForced() {
        return this.isForced;
    }

    @Override
    public Exception getException() {
        return null;
    }

    public String getString() {
        return "RunRule with version = " + this.versionString + ", force = " + this.isForced;
    }

    @Override
    public boolean allowInsecureProperties() {
        return true;
    }

    @Override
    public boolean skipThisCertArray(X509Certificate[] certs) {
        String artifactHash;
        return this.certHash != null && !this.certHash.equals(artifactHash = CertUtils.getMainCertHash(certs, this.certAlg));
    }

    @Override
    public boolean skipMetaInfDirectory() {
        return this.location != null;
    }

    @Override
    public boolean allowNativeSandbox() {
        return false;
    }

    @Override
    public boolean isUnrelatedVmSharingAllowed() {
        return true;
    }
}

