/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.security;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.LinkedList;
import java.util.jar.JarFile;

class JarIndexWrapper {
    private static final Method getMethod;
    private static final Method getJarFilesMethod;
    private static final Method getJarIndexMethod;
    private static final Method mergeMethod;
    private static final String PKG_PREFIX = "jdk.internal.util.jar";
    private static final String LEGACY_PKG_PREFIX = "sun.misc";
    private final Object jarIndex;

    private static Class<?> getJDKClass(String name) throws ClassNotFoundException {
        try {
            return Class.forName("jdk.internal.util.jar." + name);
        }
        catch (ClassNotFoundException x) {
            return Class.forName("sun.misc." + name);
        }
    }

    private JarIndexWrapper(Object jarIndex) {
        this.jarIndex = jarIndex;
    }

    public static JarIndexWrapper getJarIndex(JarFile jar) throws IOException {
        try {
            Object jarIndex = getJarIndexMethod.invoke(null, jar);
            return jarIndex == null ? null : new JarIndexWrapper(jarIndex);
        }
        catch (InvocationTargetException x) {
            if (x.getTargetException() instanceof IOException) {
                throw (IOException)x.getTargetException();
            }
            JarIndexWrapper.rethrowCause(x);
            return null;
        }
        catch (ReflectiveOperationException x) {
            throw new InternalError(x);
        }
    }

    public LinkedList<String> get(String fileName) {
        try {
            return (LinkedList)getMethod.invoke(this.jarIndex, fileName);
        }
        catch (InvocationTargetException x) {
            JarIndexWrapper.rethrowCause(x);
            return null;
        }
        catch (ReflectiveOperationException x) {
            throw new InternalError(x);
        }
    }

    public String[] getJarFiles() {
        try {
            return (String[])getJarFilesMethod.invoke(this.jarIndex, new Object[0]);
        }
        catch (InvocationTargetException x) {
            JarIndexWrapper.rethrowCause(x);
            return null;
        }
        catch (ReflectiveOperationException x) {
            throw new InternalError(x);
        }
    }

    public void merge(JarIndexWrapper toIndex, String path) {
        try {
            mergeMethod.invoke(this.jarIndex, toIndex.jarIndex, path);
        }
        catch (InvocationTargetException x) {
            JarIndexWrapper.rethrowCause(x);
        }
        catch (ReflectiveOperationException x) {
            throw new InternalError(x);
        }
    }

    private static void rethrowCause(InvocationTargetException t) {
        Throwable cause = t.getTargetException();
        if (cause instanceof RuntimeException) {
            throw (RuntimeException)cause;
        }
        if (cause instanceof Error) {
            throw (Error)cause;
        }
        throw new AssertionError((Object)t);
    }

    static {
        try {
            Class<?> c = JarIndexWrapper.getJDKClass("JarIndex");
            getMethod = c.getDeclaredMethod("get", String.class);
            getJarFilesMethod = c.getDeclaredMethod("getJarFiles", new Class[0]);
            getJarIndexMethod = c.getDeclaredMethod("getJarIndex", JarFile.class);
            mergeMethod = c.getDeclaredMethod("merge", c, String.class);
        }
        catch (ReflectiveOperationException e) {
            throw new InternalError(e);
        }
    }
}

