/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.security;

import com.sun.deploy.cache.Cache;
import com.sun.deploy.model.LocalApplicationProperties;
import com.sun.deploy.security.CertUtils;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.deploy.ui.AppInfo;
import com.sun.deploy.uitoolkit.ToolkitStore;
import com.sun.deploy.util.SecurityBaseline;
import com.sun.deploy.util.URLUtil;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.cert.X509Certificate;
import java.util.Date;

public class DecisionTime {
    private static final long ONEDAY = 86400000L;
    private static final String ALLOWED_CERT_HASH = "rdf.allowed.cert.hash";
    private static final String ALLOWED_CERT_BASE = "rdf.allowed.cert.base";
    private static final String ALLOWED_CERT_ALL_PERMISSION_GRANTED = "rdf.allowed.cert.all-perms.granted";

    public static void reset(LocalApplicationProperties lap) {
        if (lap != null) {
            lap.put("ssv.decision.unsigned.time", null);
            lap.put("ssv.decision.sandbox.time", null);
            lap.put("ssv.decision.all-perms.time", null);
            lap.put("ssv.decision.base", null);
            try {
                lap.store();
            }
            catch (IOException ioe) {
                Trace.ignoredException(ioe);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static boolean withinTime(URL base, AppInfo ai, X509Certificate cert, String key) {
        boolean secure = !SecurityBaseline.isExpired();
        LocalApplicationProperties lap = Cache.getLocalApplicationProperties(ai.getLapURL());
        if (!secure || lap == null) return false;
        String decisionTimeString = lap.get(key);
        String hash = lap.get("ssv.decision.app.hash");
        if (decisionTimeString != null && hash != null) {
            try {
                long decisionTime = Long.parseLong(decisionTimeString);
                long now = new Date().getTime();
                if (decisionTime > now) {
                    if (hash.equals(ai.getHashString()) && DecisionTime.sameBase(lap, base)) {
                        if (cert == null) {
                            return true;
                        }
                        String certHash = CertUtils.getCertificateFingerPrint("SHA-256", cert);
                        if (certHash.equals(lap.get("ssv.decision.cert.hash"))) {
                            boolean isAllPermissionGranted = key.equals("ssv.decision.all-perms.time");
                            ToolkitStore.get().getAppContext().put(ALLOWED_CERT_HASH, certHash);
                            ToolkitStore.get().getAppContext().put(ALLOWED_CERT_BASE, base);
                            ToolkitStore.get().getAppContext().put(ALLOWED_CERT_ALL_PERMISSION_GRANTED, isAllPermissionGranted);
                            return true;
                        }
                        Trace.println("Decision cert hash not matching", TraceLevel.SECURITY);
                        return false;
                    } else {
                        Trace.println("Decision hash not matching ai: " + ai, TraceLevel.SECURITY);
                    }
                    return false;
                }
                Trace.println("Decision time exceeded - show dialog", TraceLevel.SECURITY);
                return false;
            }
            catch (Exception e) {
                Trace.ignored(e);
            }
            return false;
        }
        if (cert == null) return false;
        String allowedCertHash = (String)ToolkitStore.get().getAppContext().get(ALLOWED_CERT_HASH);
        URL allowedBase = (URL)ToolkitStore.get().getAppContext().get(ALLOWED_CERT_BASE);
        if (allowedCertHash == null || allowedBase == null) return false;
        String certHash = CertUtils.getCertificateFingerPrint("SHA-256", cert);
        if (allowedCertHash.equals(certHash)) {
            if (URLUtil.sameBase(base, allowedBase)) {
                Trace.println("DecisionTime allowed cert: " + certHash, TraceLevel.SECURITY);
                if (!key.equals("ssv.decision.all-perms.time")) return true;
                Boolean isAllPermissionGranted = (Boolean)ToolkitStore.get().getAppContext().get(ALLOWED_CERT_ALL_PERMISSION_GRANTED);
                if (isAllPermissionGranted.booleanValue()) {
                    return true;
                }
                Trace.println("DecisionTime not allowed. Cert matches but not allowed for all-permissions", TraceLevel.SECURITY);
                return false;
            } else {
                Trace.println("DecisionTime not allowed. Cert matches but not same base: " + allowedBase + " vs " + base, TraceLevel.SECURITY);
            }
            return false;
        } else {
            Trace.println("DecisionTime not allowed. Cert of main app not matching cert of extension", TraceLevel.SECURITY);
        }
        return false;
    }

    protected static void setTime(URL base, AppInfo ai, X509Certificate cert, String key) {
        LocalApplicationProperties lap = Cache.getLocalApplicationProperties(ai.getLapURL());
        if (lap != null) {
            if (lap.get("ssv.decision.base") != null && !DecisionTime.sameBase(lap, base)) {
                return;
            }
            long decisionTime = new Date().getTime();
            URL from = ai.getFrom();
            if (from != null) {
                String protocol = from.getProtocol();
                decisionTime = "https".equals(protocol) && !ai.isMultiHost() ? (decisionTime += 604800000L) : (decisionTime += 86400000L);
            }
            lap.put(key, "" + decisionTime);
            lap.put("ssv.decision.app.hash", ai.getHashString());
            lap.put("ssv.decision.base", base.toString());
            if (cert != null) {
                String certHash = CertUtils.getCertificateFingerPrint("SHA-256", cert);
                lap.put("ssv.decision.cert.hash", certHash);
            }
            Trace.println("Decision time stored for ai: " + ai, TraceLevel.SECURITY);
            try {
                lap.store();
            }
            catch (IOException ioe) {
                Trace.ignoredException(ioe);
            }
        } else {
            Trace.println("Lap null for ai: " + ai, TraceLevel.SECURITY);
        }
    }

    private static boolean sameBase(LocalApplicationProperties lap, URL base) {
        String baseString;
        if (lap != null && base != null && (baseString = lap.get("ssv.decision.base")) != null) {
            try {
                URL lapBase = new URL(baseString);
                if (URLUtil.sameBase(lapBase, base)) {
                    return true;
                }
            }
            catch (MalformedURLException mue) {
                Trace.ignored(mue);
            }
        }
        return false;
    }
}

