/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.net.protocol.https;

import com.sun.deploy.config.Config;
import com.sun.deploy.security.BrowserKeystore;
import com.sun.deploy.security.X509DeployKeyManager;
import com.sun.deploy.security.X509Extended7DeployTrustManager;
import com.sun.deploy.security.X509ExtendedDeployTrustManager;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.SecureRandom;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;

public class Handler
extends sun.net.www.protocol.https.Handler {
    @Override
    protected URLConnection openConnection(URL u) throws IOException {
        Initializer.init();
        return super.openConnection(u);
    }

    static class Initializer {
        Initializer() {
        }

        static void init() {
        }

        static {
            String protocols = null;
            try {
                protocols = AccessController.doPrivileged(new PrivilegedExceptionAction<String>(){

                    @Override
                    public String run() throws Exception {
                        return System.getProperty("https.protocols");
                    }
                });
            }
            catch (PrivilegedActionException e) {
                e.printStackTrace();
            }
            if (protocols == null || protocols.trim().length() == 0) {
                boolean tlsEnabled = false;
                for (String protocol : Config.getAllTlsProtocols()) {
                    if (!Config.getBooleanProperty(protocol)) continue;
                    tlsEnabled = true;
                    break;
                }
                if (!tlsEnabled) {
                    SecurityException ex = new SecurityException("No TLS/SSL protocol is enabled.");
                    Trace.println("No TLS/SSL protocol is enabled", TraceLevel.NETWORK);
                    Trace.ignored(ex);
                    throw ex;
                }
            }
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                    @Override
                    public Void run() throws Exception {
                        if (Config.getBooleanProperty("deployment.security.browser.keystore.use")) {
                            BrowserKeystore.registerSecurityProviders();
                        }
                        SecureRandom sr = new SecureRandom();
                        SSLContext sslContext = SSLContext.getInstance("SSL");
                        Object trustManager = Config.isJavaVersionAtLeast17() ? new X509Extended7DeployTrustManager() : new X509ExtendedDeployTrustManager();
                        TrustManager[] trustManagerArray = new TrustManager[]{trustManager};
                        X509DeployKeyManager keyManager = new X509DeployKeyManager();
                        KeyManager[] keyManagerArray = new KeyManager[]{keyManager};
                        sslContext.init(keyManagerArray, trustManagerArray, sr);
                        HttpsURLConnection.setDefaultSSLSocketFactory(sslContext.getSocketFactory());
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException e) {
                e.printStackTrace();
            }
        }
    }
}

