/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.cache;

import com.sun.deploy.config.Platform;
import java.util.Properties;

final class UpgradeStatus {
    protected static final String BEGIN_TIMESTAMP_PROP_SUFFIX = "BeginTimestamp";
    protected static final String ATTEMPT_COUNT_PROP_SUFFIX = "AttemptCount";
    private static final int MAX_UPGRADE_ATTEMPTS = 5;
    private static final long RECENT_LIMIT = 1800000L;
    private final String upgradeBeginPropName;
    private final String upgradeCountPropName;
    private long lastUpgradeBeginTimestamp;
    private int upgradeAttemptCount;

    private UpgradeStatus(String upgradeBeginPropName, long lastUpgradeBeginTimestamp, String upgradeCountPropName, int upgradeAttemptCount) {
        this.upgradeBeginPropName = upgradeBeginPropName;
        this.upgradeCountPropName = upgradeCountPropName;
        this.lastUpgradeBeginTimestamp = lastUpgradeBeginTimestamp;
        this.upgradeAttemptCount = upgradeAttemptCount;
    }

    static boolean beenInitialized(String upgrader) {
        String[] propNames = UpgradeStatus.getUpgraderStatusPropNames(upgrader);
        Properties p = Platform.get().getCacheUpgradeInfo(propNames);
        return p.size() > 0;
    }

    static void initialized(String upgrader) {
        String beginPropName = upgrader + BEGIN_TIMESTAMP_PROP_SUFFIX;
        String countPropName = upgrader + ATTEMPT_COUNT_PROP_SUFFIX;
        Properties props = new Properties();
        props.setProperty(beginPropName, String.valueOf(0));
        props.setProperty(countPropName, String.valueOf(0));
        Platform.get().storeCacheUpgradeInfo(props);
    }

    static UpgradeStatus getUpgradeStatus(String upgradeBeginPropName, long upgradeBeginTimestamp, String upgradeCountPropName, int upgradeAttemptCount) {
        return new UpgradeStatus(upgradeBeginPropName, upgradeBeginTimestamp, upgradeCountPropName, upgradeAttemptCount);
    }

    static String[] getUpgraderStatusPropNames(String upgrader) {
        String beginPropName = upgrader + BEGIN_TIMESTAMP_PROP_SUFFIX;
        String countPropName = upgrader + ATTEMPT_COUNT_PROP_SUFFIX;
        return new String[]{beginPropName, countPropName};
    }

    static UpgradeStatus getUpgradeStatus(String upgrader) {
        long upgradeBegin = 0L;
        int upgradeCount = 0;
        String beginPropName = upgrader + BEGIN_TIMESTAMP_PROP_SUFFIX;
        String countPropName = upgrader + ATTEMPT_COUNT_PROP_SUFFIX;
        Properties p = Platform.get().getCacheUpgradeInfo(new String[]{beginPropName, countPropName});
        String v = p.getProperty(beginPropName);
        if (v != null) {
            try {
                upgradeBegin = Long.parseLong(v);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if ((v = p.getProperty(countPropName)) != null) {
            try {
                upgradeCount = Integer.parseInt(v);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        UpgradeStatus ret = new UpgradeStatus(beginPropName, upgradeBegin, countPropName, upgradeCount);
        return ret;
    }

    boolean isCompleted() {
        return this.upgradeAttemptCount == Integer.MAX_VALUE;
    }

    void setCompleted() {
        this.upgradeAttemptCount = Integer.MAX_VALUE;
        this.save();
    }

    boolean incrementUpgradeAttempt(int lastCount) {
        if (this.upgradeAttemptCount != lastCount) {
            return false;
        }
        ++this.upgradeAttemptCount;
        this.save();
        return true;
    }

    private void save() {
        Properties info = new Properties();
        info.put(this.upgradeBeginPropName, String.valueOf(System.currentTimeMillis()));
        info.put(this.upgradeCountPropName, String.valueOf(this.upgradeAttemptCount));
        Platform.get().storeCacheUpgradeInfo(info);
    }

    boolean isDone() {
        return this.upgradeAttemptCount >= 5;
    }

    boolean wasStartedRecently() {
        return this.lastUpgradeBeginTimestamp > 0L && System.currentTimeMillis() - this.lastUpgradeBeginTimestamp < 1800000L;
    }

    int getUpgradeAttempts() {
        return this.upgradeAttemptCount;
    }
}

