/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.cache;

import com.sun.deploy.cache.Cache;
import com.sun.deploy.cache.CacheEntry;
import com.sun.deploy.cache.MemoryCache;
import com.sun.deploy.config.Config;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.deploy.util.SystemUtils;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;

class CleanupRunnable
implements Runnable {
    private ArrayList<String> nonJarItemRemovalList = new ArrayList();
    private ArrayList<String> jarItemRemovalList = new ArrayList();
    private ArrayList<String> loadedResourceList = new ArrayList();
    private static final double CACHE_THRESHOLD_PERCENT = 0.98;
    private final Object syncObject;
    private final long currentCacheMaxSize = Config.getCacheSizeMax();
    private volatile long currentCacheSize = 0L;
    private boolean initCacheSize = true;
    private static final long BUSY_STALE_LIMIT = 3600000L;

    CleanupRunnable(Object syncObject) {
        this.syncObject = syncObject;
    }

    synchronized void addToLoadedResourceList(String url) {
        this.loadedResourceList.add(url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void startCleanup() {
        CleanupRunnable cleanupRunnable = this;
        synchronized (cleanupRunnable) {
            this.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getCurrentCacheSize() {
        long cacheSize = 0L;
        File[] cacheResourceFiles = CleanupRunnable.getCacheResourceFiles();
        for (int i = 0; i < cacheResourceFiles.length; ++i) {
            String pathname = cacheResourceFiles[i].getPath();
            File idxFile = null;
            if (cacheResourceFiles[i].isDirectory()) {
                if (!cacheResourceFiles[i].getName().toLowerCase().endsWith("-n")) {
                    CleanupRunnable.deleteFileOrDirectory(cacheResourceFiles[i]);
                    continue;
                }
                idxFile = new File(pathname.substring(0, pathname.length() - 2) + ".idx");
                if (idxFile.exists()) continue;
                CleanupRunnable.deleteFileOrDirectory(cacheResourceFiles[i]);
                continue;
            }
            idxFile = new File(pathname + ".idx");
            if (idxFile.exists()) {
                CacheEntry ce = Cache.getCacheEntryFromFile(idxFile);
                if (ce != null) {
                    cacheSize += idxFile.length();
                    cacheSize += cacheResourceFiles[i].length();
                    cacheSize += CleanupRunnable.getFileOrDirectorySize(new File(ce.getNativeLibPath()));
                    boolean addToRemovalList = true;
                    String url = ce.getURL().toLowerCase();
                    CleanupRunnable cleanupRunnable = this;
                    synchronized (cleanupRunnable) {
                        if (url.endsWith(".jnlp") || url.endsWith(".jarjnlp") || ce.getIsShortcutImage() == 1 || MemoryCache.contains(ce.getURL()) || this.loadedResourceList.contains(ce.getURL()) || ce.getBusy() == 1) {
                            addToRemovalList = false;
                        }
                    }
                    if (!addToRemovalList) continue;
                    if (url.endsWith(".jar") || url.endsWith(".jarjar") || url.endsWith(".zip")) {
                        if (this.jarItemRemovalList.contains(cacheResourceFiles[i].getPath())) continue;
                        this.jarItemRemovalList.add(cacheResourceFiles[i].getPath());
                        continue;
                    }
                    if (this.nonJarItemRemovalList.contains(cacheResourceFiles[i].getPath())) continue;
                    this.nonJarItemRemovalList.add(cacheResourceFiles[i].getPath());
                    continue;
                }
                ce = new CacheEntry(idxFile);
                if (CleanupRunnable.checkBusy(ce)) continue;
                if (!idxFile.delete()) {
                    idxFile.deleteOnExit();
                }
                if (!cacheResourceFiles[i].delete()) {
                    cacheResourceFiles[i].deleteOnExit();
                }
                CleanupRunnable.deleteFileOrDirectory(new File(pathname + "-n"));
                continue;
            }
            if (cacheResourceFiles[i].delete()) continue;
            cacheResourceFiles[i].deleteOnExit();
        }
        return cacheSize;
    }

    private static File[] getCacheResourceFiles() {
        File cacheDir = Cache.getCacheDir();
        ArrayList<File> fileList = new ArrayList<File>();
        for (int i = 0; i < 64; ++i) {
            File cacheSubDir = new File(cacheDir.getPath() + File.separator + i);
            if (!cacheSubDir.exists() || !cacheSubDir.isDirectory()) continue;
            File[] files = cacheSubDir.listFiles(new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    String filename = pathname.getName().toLowerCase();
                    return !filename.endsWith(".idx") && !filename.endsWith(".lap") && !filename.endsWith(".ico") && !filename.endsWith("-temp");
                }
            });
            for (int j = 0; j < files.length; ++j) {
                fileList.add(files[j]);
            }
        }
        return fileList.toArray(new File[fileList.size()]);
    }

    private static long getFileOrDirectorySize(File f) {
        long size = 0L;
        if (f.exists()) {
            if (f.isDirectory()) {
                File[] files = f.listFiles();
                for (int i = 0; i < files.length; ++i) {
                    size += CleanupRunnable.getFileOrDirectorySize(files[i]);
                }
            } else {
                size += f.length();
            }
        }
        return size;
    }

    private static void deleteFileOrDirectory(File f) {
        if (f.exists()) {
            if (f.isDirectory()) {
                File[] files = f.listFiles();
                for (int i = 0; i < files.length; ++i) {
                    CleanupRunnable.deleteFileOrDirectory(files[i]);
                }
            }
            f.delete();
        }
    }

    private Object[] prepareRemovalList(ArrayList<String> removalList) {
        ArrayList<CacheEntry> cacheEntryList = new ArrayList<CacheEntry>();
        for (String resourceFilePath : removalList) {
            File indexFile = new File(resourceFilePath + ".idx");
            if (!indexFile.exists()) continue;
            CacheEntry ce = Cache.getCacheEntryFromFile(indexFile);
            cacheEntryList.add(ce);
        }
        Object[] cacheEntryArray = (CacheEntry[])cacheEntryList.toArray();
        Arrays.sort(cacheEntryArray, new Comparator<CacheEntry>(){

            @Override
            public int compare(CacheEntry ce1, CacheEntry ce2) {
                if (ce1.removeBefore(ce2)) {
                    return -1;
                }
                if (ce2.removeBefore(ce1)) {
                    return 1;
                }
                return 0;
            }
        });
        return cacheEntryArray;
    }

    private void removeResourceFromList(Object[] cacheEntryArray) {
        long cacheThreshold = (long)((double)this.currentCacheMaxSize * 0.98);
        for (int i = 0; i < cacheEntryArray.length && this.currentCacheSize >= cacheThreshold; ++i) {
            CacheEntry ce = (CacheEntry)cacheEntryArray[i];
            long size = ce.getIndexFile().length() + new File(ce.getResourceFilename()).length() + CleanupRunnable.getFileOrDirectorySize(new File(ce.getNativeLibPath()));
            Cache.removeCacheEntry(ce);
            this.currentCacheSize -= size;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (true) {
            try {
                while (true) {
                    CleanupRunnable cleanupRunnable = this;
                    synchronized (cleanupRunnable) {
                        this.wait();
                    }
                    long t0 = SystemUtils.microTime();
                    Object object = this.syncObject;
                    synchronized (object) {
                        if (this.initCacheSize) {
                            this.currentCacheSize = this.getCurrentCacheSize();
                            this.initCacheSize = false;
                        }
                        if (this.currentCacheMaxSize != -1L && this.currentCacheSize >= this.currentCacheMaxSize) {
                            Object[] resourceList = this.prepareRemovalList(this.nonJarItemRemovalList);
                            this.removeResourceFromList(resourceList);
                            resourceList = this.prepareRemovalList(this.jarItemRemovalList);
                            this.removeResourceFromList(resourceList);
                        }
                    }
                    long dT = SystemUtils.microTime() - t0;
                    Trace.println(ResourceManager.getString("console.trace.plugin.applet.cleanup") + dT + " us", TraceLevel.NETWORK);
                }
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    private static boolean checkBusy(CacheEntry ce) {
        CacheEntry loadedCE;
        Object obj = MemoryCache.getLoadedResource(ce.getURL());
        CacheEntry cacheEntry = loadedCE = obj instanceof CacheEntry ? (CacheEntry)obj : null;
        if (ce.isSameEntry(loadedCE)) {
            return true;
        }
        if (ce.getBusy() == 1) {
            long lastModified = ce.getIndexFile().lastModified();
            if (System.currentTimeMillis() - lastModified < 3600000L) {
                return true;
            }
        }
        return false;
    }
}

