/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin.dom.core;

import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.w3c.dom.TypeInfo;
import sun.plugin.dom.DOMObject;
import sun.plugin.dom.DOMObjectFactory;
import sun.plugin.dom.DOMObjectHelper;
import sun.plugin.dom.core.Attr;
import sun.plugin.dom.core.Node;
import sun.plugin.dom.exception.PluginNotSupportedException;
import sun.plugin.dom.html.HTMLDocument;

public abstract class Element
extends Node
implements org.w3c.dom.Element {
    private static final String ATTR_TAGNAME = "tagName";

    protected Element(DOMObject obj, Document doc) {
        super(obj, doc);
    }

    @Override
    public String getTagName() {
        return this.getAttribute(ATTR_TAGNAME);
    }

    @Override
    public String getAttribute(String name) {
        return DOMObjectHelper.getStringMemberNoEx(this.obj, name);
    }

    @Override
    public void setAttribute(String name, String value) throws DOMException {
        DOMObjectHelper.setStringMember(this.obj, name, value);
    }

    @Override
    public void removeAttribute(String name) throws DOMException {
        throw new PluginNotSupportedException("Element.removeAttribute() is not supported");
    }

    @Override
    public org.w3c.dom.Attr getAttributeNode(String name) {
        return DOMObjectFactory.createAttr(this.obj.call("getAttributeNode", new Object[]{name}), this.getOwnerDocument());
    }

    @Override
    public org.w3c.dom.Attr setAttributeNode(org.w3c.dom.Attr newAttr) throws DOMException {
        return DOMObjectFactory.createAttr(this.obj.call("setAttributeNode", new Object[]{((Attr)newAttr).getDOMObject()}), this.getOwnerDocument());
    }

    @Override
    public org.w3c.dom.Attr removeAttributeNode(org.w3c.dom.Attr oldAttr) throws DOMException {
        return DOMObjectFactory.createAttr(this.obj.call("removeAttributeNode", new Object[]{((Attr)oldAttr).getDOMObject()}), this.getOwnerDocument());
    }

    @Override
    public NodeList getElementsByTagName(String name) {
        return DOMObjectFactory.createNodeList(this.obj.call("getElementsByTagName", new Object[]{name}), (HTMLDocument)this.getOwnerDocument());
    }

    @Override
    public String getAttributeNS(String namespaceURI, String localName) {
        try {
            return (String)this.obj.call("getAttributeNS", new Object[]{namespaceURI, localName});
        }
        catch (DOMException dOMException) {
            return null;
        }
    }

    @Override
    public void setAttributeNS(String namespaceURI, String qualifiedName, String value) throws DOMException {
        this.obj.call("setAttributeNS", new Object[]{namespaceURI, qualifiedName, value});
    }

    @Override
    public void removeAttributeNS(String namespaceURI, String localName) throws DOMException {
        this.obj.call("removeAttributeNS", new Object[]{namespaceURI, localName});
    }

    @Override
    public org.w3c.dom.Attr getAttributeNodeNS(String namespaceURI, String localName) {
        return DOMObjectFactory.createAttr(this.obj.call("getAttributeNodeNS", new Object[]{namespaceURI, localName}), this.getOwnerDocument());
    }

    @Override
    public org.w3c.dom.Attr setAttributeNodeNS(org.w3c.dom.Attr newAttr) throws DOMException {
        return DOMObjectFactory.createAttr(this.obj.call("setAttributeNodeNS", new Object[]{((Attr)newAttr).getDOMObject()}), this.getOwnerDocument());
    }

    @Override
    public NodeList getElementsByTagNameNS(String namespaceURI, String localName) {
        return DOMObjectFactory.createNodeList(this.obj.call("getElementsByTagNameNS", new Object[]{namespaceURI, localName}), (HTMLDocument)this.getOwnerDocument());
    }

    @Override
    public boolean hasAttribute(String name) {
        return this.getAttribute(name) != null;
    }

    @Override
    public boolean hasAttributeNS(String namespaceURI, String localName) {
        try {
            return (Boolean)this.obj.call("hasAttributeNS", new Object[]{namespaceURI, localName});
        }
        catch (Exception exception) {
            return false;
        }
    }

    @Override
    public String getNodeValue() throws DOMException {
        throw new PluginNotSupportedException("Element.getNodeValue() is not supported");
    }

    @Override
    public void setNodeValue(String nodeValue) throws DOMException {
        throw new PluginNotSupportedException("Element.setNodeValue() is not supported");
    }

    @Override
    public void setIdAttribute(String name, boolean isId) throws DOMException {
        throw new PluginNotSupportedException("Element.setIdAttribute() is not supported");
    }

    @Override
    public void setIdAttributeNS(String namespaceURI, String localName, boolean isId) throws DOMException {
        throw new PluginNotSupportedException("Element.setIdAttributeNS() is not supported");
    }

    @Override
    public void setIdAttributeNode(org.w3c.dom.Attr idAttr, boolean isId) throws DOMException {
        throw new PluginNotSupportedException("Element.setIdAttributeNode() is not supported");
    }

    @Override
    public TypeInfo getSchemaTypeInfo() {
        throw new PluginNotSupportedException("Element.getSchemaTypeInfo is not supported");
    }
}

