/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin.dom.core;

import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import sun.plugin.dom.DOMObject;
import sun.plugin.dom.DOMObjectHelper;
import sun.plugin.dom.core.Node;

class CharacterData
extends Node
implements org.w3c.dom.CharacterData {
    private static final String ATTR_DATA = "data";
    private static final String ATTR_LENGTH = "length";
    private static final String FUNC_SUBSTRING_DATA = "substringData";
    private static final String FUNC_APPEND_DATA = "appendData";
    private static final String FUNC_INSERT_DATA = "insertData";
    private static final String FUNC_DELETE_DATA = "deleteData";
    private static final String FUNC_REPLACE_DATA = "replaceData";

    protected CharacterData(DOMObject obj, Document doc) {
        super(obj, doc);
    }

    @Override
    public String getData() throws DOMException {
        return DOMObjectHelper.getStringMemberNoEx(this.obj, ATTR_DATA);
    }

    @Override
    public void setData(String data) throws DOMException {
        DOMObjectHelper.setStringMember(this.obj, ATTR_DATA, data);
    }

    @Override
    public int getLength() {
        return DOMObjectHelper.getIntMemberNoEx(this.obj, ATTR_LENGTH);
    }

    @Override
    public String substringData(int offset, int count) throws DOMException {
        Object[] args = new Object[]{new Integer(offset), new Integer(count)};
        return DOMObjectHelper.callStringMethod(this.obj, FUNC_SUBSTRING_DATA, args);
    }

    @Override
    public void appendData(String arg) throws DOMException {
        Object[] args = new Object[]{arg};
        this.obj.call(FUNC_APPEND_DATA, args);
    }

    @Override
    public void insertData(int offset, String arg) throws DOMException {
        Object[] args = new Object[]{new Integer(offset), arg};
        this.obj.call(FUNC_INSERT_DATA, args);
    }

    @Override
    public void deleteData(int offset, int count) throws DOMException {
        Object[] args = new Object[]{new Integer(offset), new Integer(count)};
        this.obj.call(FUNC_DELETE_DATA, args);
    }

    @Override
    public void replaceData(int offset, int count, String arg) throws DOMException {
        Object[] args = new Object[]{new Integer(offset), new Integer(count), arg};
        this.obj.call(FUNC_REPLACE_DATA, args);
    }

    @Override
    public String getNodeValue() throws DOMException {
        return this.getData();
    }

    @Override
    public void setNodeValue(String nodeValue) throws DOMException {
        this.setData(nodeValue);
    }
}

